/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Providers;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JOptionPane;
import org.apache.commons.vfs2.FileObject;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.job.AnalysisJobMetadata;
import org.eobjects.analyzer.job.JaxbJobReader;
import org.eobjects.analyzer.job.NoSuchDatastoreException;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.result.AnalysisResult;
import org.eobjects.analyzer.util.ChangeAwareObjectInputStream;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.DCModule;
import org.eobjects.datacleaner.user.ExtensionPackage;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.widgets.DCFileChooser;
import org.eobjects.datacleaner.widgets.OpenAnalysisJobFileChooserAccessory;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;
import org.eobjects.datacleaner.windows.OpenAnalysisJobAsTemplateDialog;
import org.eobjects.datacleaner.windows.ResultWindow;

public class OpenAnalysisJobActionListener
implements ActionListener {
    private final AnalyzerBeansConfiguration _configuration;
    private final AnalysisJobBuilderWindow _parentWindow;
    private final WindowContext _windowContext;
    private final DCModule _parentModule;
    private final UserPreferences _userPreferences;
    private final UsageLogger _usageLogger;

    @Inject
    public OpenAnalysisJobActionListener(AnalysisJobBuilderWindow parentWindow, AnalyzerBeansConfiguration configuration, WindowContext windowContext, DCModule parentModule, UserPreferences userPreferences, UsageLogger usageLogger) {
        this._parentWindow = parentWindow;
        this._configuration = configuration;
        this._windowContext = windowContext;
        this._parentModule = parentModule;
        this._userPreferences = userPreferences;
        this._usageLogger = usageLogger;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this._usageLogger.log("Open analysis job");
        DCFileChooser fileChooser = new DCFileChooser(this._userPreferences.getAnalysisJobDirectory());
        OpenAnalysisJobFileChooserAccessory accessory = new OpenAnalysisJobFileChooserAccessory(this._windowContext, this._configuration, fileChooser, (Provider<OpenAnalysisJobActionListener>)Providers.of((Object)this));
        fileChooser.setAccessory(accessory);
        fileChooser.addChoosableFileFilter(FileFilters.ANALYSIS_XML);
        fileChooser.addChoosableFileFilter(FileFilters.ANALYSIS_RESULT_SER);
        fileChooser.setFileFilter(FileFilters.combined("DataCleaner analysis files", FileFilters.ANALYSIS_XML, FileFilters.ANALYSIS_RESULT_SER));
        int openFileResult = fileChooser.showOpenDialog((Component)event.getSource());
        if (openFileResult == 0) {
            FileObject file = fileChooser.getSelectedFileObject();
            this.openFile(file);
        }
    }

    public static Injector open(FileObject file, AnalyzerBeansConfiguration configuration, Injector injector) {
        UserPreferences userPreferences = (UserPreferences)injector.getInstance(UserPreferences.class);
        OpenAnalysisJobActionListener openAnalysisJobActionListener = new OpenAnalysisJobActionListener(null, configuration, null, (DCModule)((Object)injector.getInstance(DCModule.class)), userPreferences, null);
        return openAnalysisJobActionListener.openAnalysisJob(file);
    }

    public void openFile(FileObject file) {
        if (file.getName().getBaseName().endsWith(FileFilters.ANALYSIS_RESULT_SER.getExtension())) {
            this.openAnalysisResult(file, this._parentModule);
        } else {
            Injector injector = this.openAnalysisJob(file);
            AnalysisJobBuilderWindow window = (AnalysisJobBuilderWindow)injector.getInstance(AnalysisJobBuilderWindow.class);
            window.open();
            if (this._parentWindow != null && !this._parentWindow.isDatastoreSet()) {
                this._parentWindow.close();
            }
        }
    }

    public ResultWindow openAnalysisResult(final FileObject fileObject, DCModule parentModule) {
        AnalysisResult analysisResult;
        try {
            ChangeAwareObjectInputStream is = new ChangeAwareObjectInputStream(fileObject.getContent().getInputStream());
            is.addClassLoader(ExtensionPackage.getExtensionClassLoader());
            analysisResult = (AnalysisResult)is.readObject();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        File file = VFSUtils.toFile((FileObject)fileObject);
        if (file != null) {
            this._userPreferences.setAnalysisJobDirectory(file.getParentFile());
            this._userPreferences.addRecentJobFile(fileObject);
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new DCModule(parentModule, null){

            @Override
            public FileObject getJobFilename() {
                return fileObject;
            }

            @Override
            public AnalysisResult getAnalysisResult() {
                return analysisResult;
            }

            @Override
            public AnalysisJobBuilder getAnalysisJobBuilder(AnalyzerBeansConfiguration configuration) {
                return null;
            }
        }});
        ResultWindow resultWindow = (ResultWindow)injector.getInstance(ResultWindow.class);
        resultWindow.open();
        return resultWindow;
    }

    public Injector openAnalysisJob(FileObject file) {
        JaxbJobReader reader = new JaxbJobReader(this._configuration);
        try {
            AnalysisJobBuilder ajb = reader.create(file);
            return this.openAnalysisJob(file, ajb);
        }
        catch (NoSuchDatastoreException e) {
            if (this._windowContext == null) {
                throw e;
            }
            AnalysisJobMetadata metadata = reader.readMetadata(file);
            int result = JOptionPane.showConfirmDialog(null, e.getMessage() + "\n\nDo you wish to open this job as a template?", "Error: " + e.getMessage(), 2, 0);
            if (result == 0) {
                OpenAnalysisJobAsTemplateDialog dialog = new OpenAnalysisJobAsTemplateDialog(this._windowContext, this._configuration, file, metadata, (Provider<OpenAnalysisJobActionListener>)Providers.of((Object)this));
                dialog.setVisible(true);
            }
            return null;
        }
    }

    public Injector openAnalysisJob(final FileObject fileObject, AnalysisJobBuilder ajb) {
        File file = VFSUtils.toFile((FileObject)fileObject);
        if (file != null) {
            this._userPreferences.setAnalysisJobDirectory(file.getParentFile());
            this._userPreferences.addRecentJobFile(fileObject);
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new DCModule(this._parentModule, ajb){

            @Override
            public FileObject getJobFilename() {
                return fileObject;
            }
        }});
        return injector;
    }
}

