/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.windows.DataSetWindow;
import org.eobjects.metamodel.DataContext;
import org.eobjects.metamodel.query.Query;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

public class PreviewSourceDataActionListener
implements ActionListener {
    private static final int PAGE_SIZE = 35;
    private final Datastore _datastore;
    private final Column[] _columns;
    private final Collection<? extends InputColumn<?>> _inputColumns;
    private final WindowContext _windowContext;

    public PreviewSourceDataActionListener(WindowContext windowContext, Datastore datastore, Column ... columns) {
        this._windowContext = windowContext;
        this._datastore = datastore;
        this._columns = columns;
        this._inputColumns = null;
    }

    public PreviewSourceDataActionListener(WindowContext windowContext, Datastore datastore, Table table) {
        this(windowContext, datastore, table.getColumns());
    }

    public PreviewSourceDataActionListener(WindowContext windowContext, Datastore datastore, Collection<? extends InputColumn<?>> inputColumns) {
        this._windowContext = windowContext;
        this._datastore = datastore;
        this._inputColumns = inputColumns;
        this._columns = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Column[] columns = this._columns;
        if (columns == null) {
            ArrayList<Column> cols = new ArrayList<Column>();
            for (InputColumn<?> col : this._inputColumns) {
                if (!col.isPhysicalColumn()) continue;
                cols.add(col.getPhysicalColumn());
            }
            columns = cols.toArray(new Column[cols.size()]);
        }
        if (columns.length == 0) {
            throw new IllegalStateException("No columns found - could not determine which columns to query");
        }
        DatastoreConnection con = this._datastore.openConnection();
        try {
            DataContext dc = con.getDataContext();
            Query q = dc.query().from(columns[0].getTable()).select(columns).toQuery();
            DataSetWindow window = new DataSetWindow(q, dc, 35, this._windowContext);
            window.setVisible(true);
        }
        finally {
            con.close();
        }
    }
}

