/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eobjects.analyzer.beans.filter.MaxRowsFilter;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.Descriptors;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.JaxbJobReader;
import org.eobjects.analyzer.job.JaxbJobWriter;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.analyzer.job.runner.AnalysisResultFuture;
import org.eobjects.analyzer.job.runner.AnalysisRunnerImpl;
import org.eobjects.analyzer.util.SourceColumnFinder;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.TransformerJobBuilderPresenter;
import org.eobjects.datacleaner.util.PreviewTransformedDataAnalyzer;
import org.eobjects.datacleaner.windows.DataSetWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreviewTransformedDataActionListener
implements ActionListener,
Callable<TableModel> {
    private static final Logger logger = LoggerFactory.getLogger(PreviewTransformedDataActionListener.class);
    public static final int DEFAULT_PREVIEW_ROWS = 200;
    private final TransformerJobBuilderPresenter _transformerJobBuilderPresenter;
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final TransformerJobBuilder<?> _transformerJobBuilder;
    private final WindowContext _windowContext;
    private final AnalyzerBeansConfiguration _configuration;

    public PreviewTransformedDataActionListener(WindowContext windowContext, TransformerJobBuilderPresenter transformerJobBuilderPresenter, AnalysisJobBuilder analysisJobBuilder, TransformerJobBuilder<?> transformerJobBuilder, AnalyzerBeansConfiguration configuration) {
        this._windowContext = windowContext;
        this._transformerJobBuilderPresenter = transformerJobBuilderPresenter;
        this._analysisJobBuilder = analysisJobBuilder;
        this._transformerJobBuilder = transformerJobBuilder;
        this._configuration = configuration;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataSetWindow window = new DataSetWindow("Preview of transformed dataset", this, this._windowContext);
        window.setVisible(true);
    }

    @Override
    public TableModel call() throws Exception {
        if (this._transformerJobBuilderPresenter != null) {
            this._transformerJobBuilderPresenter.applyPropertyValues();
        }
        AnalysisJobBuilder ajb = this.copy(this._analysisJobBuilder);
        TransformerJobBuilder<?> tjb = this.findTransformerJobBuilder(ajb, this._transformerJobBuilder);
        ajb.removeAllAnalyzers();
        AnalyzerJobBuilder rowCollector = (AnalyzerJobBuilder)((AnalyzerJobBuilder)ajb.addAnalyzer(Descriptors.ofAnalyzer(PreviewTransformedDataAnalyzer.class)).addInputColumns((Collection)tjb.getInputColumns())).addInputColumns((Collection)tjb.getOutputColumns());
        if (tjb.getRequirement() != null) {
            rowCollector.setRequirement(tjb.getRequirement());
        }
        FilterJobBuilder maxRowFilter = ajb.addFilter(MaxRowsFilter.class);
        ((MaxRowsFilter)maxRowFilter.getConfigurableBean()).setMaxRows(200);
        ajb.setDefaultRequirement(maxRowFilter, (Enum)MaxRowsFilter.Category.VALID);
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(ajb);
        Object[] columnNames = new String[rowCollector.getInputColumns().size()];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = ((InputColumn)rowCollector.getInputColumns().get(i)).getName();
        }
        AnalysisRunnerImpl runner = new AnalysisRunnerImpl(ajb.getConfiguration());
        AnalysisResultFuture resultFuture = runner.run(ajb.toAnalysisJob());
        resultFuture.await();
        if (resultFuture.isErrornous()) {
            List errors = resultFuture.getErrors();
            Throwable firstError = (Throwable)errors.get(0);
            logger.error("Error occurred while running preview data job: {}", (Object)firstError.getMessage());
            for (Throwable throwable : errors) {
                logger.info("Preview data error", throwable);
            }
            if (firstError instanceof Exception) {
                throw (Exception)firstError;
            }
            throw new IllegalStateException(firstError);
        }
        List results = resultFuture.getResults();
        assert (results.size() == 1);
        PreviewTransformedDataAnalyzer result = (PreviewTransformedDataAnalyzer)results.get(0);
        List<Object[]> rows = result.getList();
        DefaultTableModel tableModel = new DefaultTableModel(columnNames, rows.size());
        int rowIndex = 0;
        for (Object[] row : rows) {
            for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                tableModel.setValueAt(row[columnIndex], rowIndex, columnIndex);
            }
            ++rowIndex;
        }
        return tableModel;
    }

    private TransformerJobBuilder<?> findTransformerJobBuilder(AnalysisJobBuilder ajb, TransformerJobBuilder<?> transformerJobBuilder) {
        int transformerIndex = this._analysisJobBuilder.getTransformerJobBuilders().indexOf(this._transformerJobBuilder);
        return (TransformerJobBuilder)ajb.getTransformerJobBuilders().get(transformerIndex);
    }

    private AnalysisJobBuilder copy(AnalysisJobBuilder original) {
        AnalysisJob analysisJob = original.withoutListeners().toAnalysisJob(false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new JaxbJobWriter(this._configuration).write(analysisJob, (OutputStream)baos);
        AnalysisJobBuilder ajb = new JaxbJobReader(original.getConfiguration()).create((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return ajb;
    }
}

