/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.swing.SwingWorker;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.codehaus.jackson.map.ObjectMapper;
import org.eobjects.analyzer.job.tasks.Task;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.user.MonitorConnection;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.windows.FileTransferProgressWindow;
import org.eobjects.datacleaner.windows.MonitorConnectionDialog;
import org.eobjects.metamodel.util.FileHelper;
import org.jdesktop.swingx.action.OpenBrowserAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PublishFileToMonitorActionListener
extends SwingWorker<Map<?, ?>, Task>
implements ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(PublishFileToMonitorActionListener.class);
    private final WindowContext _windowContext;
    private final UserPreferences _userPreferences;
    private final HttpClient _httpClient;
    private FileTransferProgressWindow _progressWindow;

    public PublishFileToMonitorActionListener(WindowContext windowContext, UserPreferences userPreferences, HttpClient httpClient) {
        this._windowContext = windowContext;
        this._userPreferences = userPreferences;
        this._httpClient = httpClient;
    }

    protected abstract String getTransferredFilename();

    protected abstract String getUploadUrl(MonitorConnection var1);

    protected abstract InputStream getTransferStream();

    protected abstract long getExpectedSize();

    protected boolean openBrowserWhenDone() {
        return false;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        MonitorConnection monitorConnection = this._userPreferences.getMonitorConnection();
        if (monitorConnection == null) {
            MonitorConnectionDialog dialog = new MonitorConnectionDialog(this._windowContext, this._userPreferences, this._httpClient);
            dialog.open();
        } else {
            this._progressWindow = new FileTransferProgressWindow(this._windowContext, null, new String[]{this.getTransferredFilename()});
            this._progressWindow.open();
            this.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<?, ?> doInBackground() throws Exception {
        StatusLine statusLine;
        block6: {
            String contentString;
            HttpResponse response;
            MonitorConnection monitorConnection = this._userPreferences.getMonitorConnection();
            monitorConnection.prepareClient(this._httpClient);
            String uploadUrl = this.getUploadUrl(monitorConnection);
            logger.debug("Upload url: {}", (Object)uploadUrl);
            HttpPost request = new HttpPost(uploadUrl);
            final long expectedSize = this.getExpectedSize();
            this.publish(new Task(){

                public void execute() throws Exception {
                    PublishFileToMonitorActionListener.this._progressWindow.setExpectedSize(PublishFileToMonitorActionListener.this.getTransferredFilename(), expectedSize);
                }
            });
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            AbstractContentBody uploadFilePart = new AbstractContentBody("application/octet-stream"){

                public String getCharset() {
                    return null;
                }

                public String getTransferEncoding() {
                    return "binary";
                }

                public long getContentLength() {
                    return expectedSize;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeTo(OutputStream out) throws IOException {
                    long progress = 0L;
                    InputStream in = PublishFileToMonitorActionListener.this.getTransferStream();
                    try {
                        int length;
                        byte[] tmp = new byte[4096];
                        while ((length = in.read(tmp)) != -1) {
                            out.write(tmp, 0, length);
                            final long updatedProgress = progress += (long)length;
                            PublishFileToMonitorActionListener.this.publish(new Task[]{new Task(){

                                public void execute() throws Exception {
                                    PublishFileToMonitorActionListener.this._progressWindow.setProgress(PublishFileToMonitorActionListener.this.getTransferredFilename(), updatedProgress);
                                }
                            }});
                        }
                        out.flush();
                    }
                    finally {
                        in.close();
                    }
                }

                public String getFilename() {
                    return PublishFileToMonitorActionListener.this.getTransferredFilename();
                }
            };
            entity.addPart("file", (ContentBody)uploadFilePart);
            request.setEntity((HttpEntity)entity);
            try {
                response = this._httpClient.execute((HttpUriRequest)request);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() != 200) break block6;
            logger.info("Upload response status: {}", (Object)statusLine);
            InputStream content = response.getEntity().getContent();
            try {
                contentString = FileHelper.readInputStreamAsString((InputStream)content, (String)"UTF-8");
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{content});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{content});
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                Map responseMap = (Map)objectMapper.readValue(contentString, Map.class);
                return responseMap;
            }
            catch (Exception e) {
                logger.warn("Received non-JSON response:\n{}", (Object)contentString);
                logger.error("Failed to parse response as JSON", (Throwable)e);
                return null;
            }
        }
        logger.warn("Upload response status: {}", (Object)statusLine);
        String reasonPhrase = statusLine.getReasonPhrase();
        WidgetUtils.showErrorMessage("Server reported error", "Server replied with status " + statusLine.getStatusCode() + ":\n" + reasonPhrase, null);
        return null;
    }

    @Override
    protected void process(List<Task> chunks) {
        for (Task task : chunks) {
            try {
                task.execute();
            }
            catch (Exception e) {
                WidgetUtils.showErrorMessage("Error processing transfer chunk: " + task, e);
            }
        }
    }

    @Override
    protected void done() {
        Map responseMap;
        try {
            responseMap = (Map)this.get();
        }
        catch (Exception e) {
            WidgetUtils.showErrorMessage("Error transfering file(s)!", e);
            return;
        }
        this._progressWindow.setFinished(this.getTransferredFilename());
        if (this.openBrowserWhenDone() && responseMap != null) {
            MonitorConnection monitorConnection = this._userPreferences.getMonitorConnection();
            String repositoryPath = responseMap.get("repository_path").toString();
            OpenBrowserAction openBrowserAction = new OpenBrowserAction(monitorConnection.getBaseUrl() + "/repository" + PublishFileToMonitorActionListener.encodeSpaces(repositoryPath));
            openBrowserAction.actionPerformed(null);
        }
    }

    protected static String encodeSpaces(String str) {
        return str.replaceAll(" ", "\\+");
    }
}

