/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.http.client.HttpClient;
import org.eobjects.analyzer.result.AnalysisResult;
import org.eobjects.analyzer.result.SimpleAnalysisResult;
import org.eobjects.datacleaner.actions.PublishFileToMonitorActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.JobFile;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.user.MonitorConnection;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.metamodel.util.Ref;

public class PublishResultToMonitorActionListener
extends PublishFileToMonitorActionListener {
    private final Ref<AnalysisResult> _resultRef;
    private final FileObject _jobFilename;
    private byte[] _bytes;

    public PublishResultToMonitorActionListener(WindowContext windowContext, UserPreferences userPreferences, Ref<AnalysisResult> resultRef, HttpClient httpClient, @Nullable @JobFile FileObject jobFilename) {
        super(windowContext, userPreferences, httpClient);
        this._resultRef = resultRef;
        this._jobFilename = jobFilename;
    }

    private byte[] getBytes() {
        if (this._bytes == null) {
            AnalysisResult analysisResult = (AnalysisResult)this._resultRef.get();
            this._bytes = SerializationUtils.serialize((Serializable)new SimpleAnalysisResult(analysisResult.getResultMap()));
        }
        return this._bytes;
    }

    @Override
    protected String getTransferredFilename() {
        String jobExtension = FileFilters.ANALYSIS_XML.getExtension();
        String baseName = this._jobFilename.getName().getBaseName();
        if (baseName.endsWith(jobExtension)) {
            baseName = baseName.substring(0, baseName.length() - jobExtension.length());
        }
        return baseName;
    }

    @Override
    protected String getUploadUrl(MonitorConnection monitorConnection) {
        String transferredFilename = this.getTransferredFilename();
        String encodedFilename = PublishResultToMonitorActionListener.encodeSpaces(transferredFilename);
        return monitorConnection.getBaseUrl() + "/repository/" + monitorConnection.getTenantId() + "/results/" + encodedFilename;
    }

    @Override
    protected long getExpectedSize() {
        return this.getBytes().length;
    }

    @Override
    protected InputStream getTransferStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    @Override
    protected boolean openBrowserWhenDone() {
        return true;
    }
}

