/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.BooleanAnalyzer;
import org.eobjects.analyzer.beans.DateAndTimeAnalyzer;
import org.eobjects.analyzer.beans.NumberAnalyzer;
import org.eobjects.analyzer.beans.StringAnalyzer;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.stringpattern.PatternFinderAnalyzer;
import org.eobjects.analyzer.beans.valuedist.ValueDistributionAnalyzer;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MetaModelInputColumn;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.datacleaner.actions.RunAnalysisActionListener;
import org.eobjects.datacleaner.guice.DCModule;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.user.QuickAnalysisStrategy;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;

public class QuickAnalysisActionListener
implements ActionListener {
    private final Datastore _datastore;
    private final Table _table;
    private final Column[] _columns;
    private final DCModule _parentModule;
    private final UserPreferences _userPreferences;
    private final AnalyzerBeansConfiguration _configuration;

    @Inject
    protected QuickAnalysisActionListener(Datastore datastore, @Nullable Table table, @Nullable Column[] columns, DCModule parentModule, UserPreferences userPreferences, AnalyzerBeansConfiguration configuration) {
        this._datastore = datastore;
        this._table = table;
        this._columns = columns;
        this._parentModule = parentModule;
        this._userPreferences = userPreferences;
        this._configuration = configuration;
    }

    public Column[] getColumns() {
        if (this._columns == null) {
            return this._table.getColumns();
        }
        return this._columns;
    }

    public Table getTable() {
        if (this._table == null) {
            return this._columns[0].getTable();
        }
        return this._table;
    }

    public static void configureAnalysisJobBuilder(AnalysisJobBuilder ajb, QuickAnalysisStrategy quickAnalysisStrategy) {
        ArrayList<MetaModelInputColumn> booleanColumns = new ArrayList<MetaModelInputColumn>();
        ArrayList stringColumns = new ArrayList();
        ArrayList numberColumns = new ArrayList();
        ArrayList dateTimeColumns = new ArrayList();
        for (MetaModelInputColumn inputColumn : ajb.getSourceColumns()) {
            Class dataType = inputColumn.getDataType();
            if (ReflectionUtils.isBoolean((Type)dataType)) {
                booleanColumns.add(inputColumn);
                continue;
            }
            if (ReflectionUtils.isNumber((Type)dataType)) {
                numberColumns.add((InputColumn<?>)inputColumn);
                continue;
            }
            if (ReflectionUtils.isDate((Type)dataType)) {
                dateTimeColumns.add((InputColumn<?>)inputColumn);
                continue;
            }
            if (!ReflectionUtils.isString((Type)dataType)) continue;
            stringColumns.add((InputColumn<?>)inputColumn);
        }
        if (!booleanColumns.isEmpty()) {
            ajb.addAnalyzer(BooleanAnalyzer.class).addInputColumns(booleanColumns);
        }
        if (!numberColumns.isEmpty()) {
            QuickAnalysisActionListener.createAnalyzers(ajb, NumberAnalyzer.class, numberColumns, quickAnalysisStrategy);
        }
        if (!dateTimeColumns.isEmpty()) {
            QuickAnalysisActionListener.createAnalyzers(ajb, DateAndTimeAnalyzer.class, dateTimeColumns, quickAnalysisStrategy);
        }
        if (!stringColumns.isEmpty()) {
            QuickAnalysisActionListener.createAnalyzers(ajb, StringAnalyzer.class, stringColumns, quickAnalysisStrategy);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        AnalysisJobBuilder ajb = new AnalysisJobBuilder(this._configuration);
        ajb.setDatastore(this._datastore);
        ajb.addSourceColumns(this.getColumns());
        QuickAnalysisStrategy quickAnalysisStrategy = this._userPreferences.getQuickAnalysisStrategy();
        QuickAnalysisActionListener.configureAnalysisJobBuilder(ajb, quickAnalysisStrategy);
        try {
            if (!ajb.isConfigured(true)) {
                throw new IllegalStateException("Unknown job configuration issue!");
            }
            Injector injector = Guice.createInjector((Module[])new Module[]{new DCModule(this._parentModule, ajb)});
            RunAnalysisActionListener actionListener = (RunAnalysisActionListener)injector.getInstance(RunAnalysisActionListener.class);
            actionListener.actionPerformed(event);
        }
        catch (Exception e) {
            WidgetUtils.showErrorMessage("Error", "Could not perform quick analysis on table " + this._table.getName(), e);
        }
    }

    private static void createAnalyzers(AnalysisJobBuilder ajb, Class<? extends Analyzer<?>> analyzerClass, List<InputColumn<?>> columns, QuickAnalysisStrategy quickAnalysisStrategy) {
        int columnsPerAnalyzer = quickAnalysisStrategy.getColumnsPerAnalyzer();
        AnalyzerJobBuilder analyzerJobBuilder = ajb.addAnalyzer(analyzerClass);
        int columnCount = 0;
        for (InputColumn<?> inputColumn : columns) {
            if (columnCount == columnsPerAnalyzer) {
                analyzerJobBuilder = ajb.addAnalyzer(analyzerClass);
                columnCount = 0;
            }
            analyzerJobBuilder.addInputColumn(inputColumn);
            if (quickAnalysisStrategy.isIncludeValueDistribution()) {
                ajb.addAnalyzer(ValueDistributionAnalyzer.class).addInputColumn(inputColumn);
            }
            if (inputColumn.getDataType() == String.class && quickAnalysisStrategy.isIncludePatternFinder()) {
                ajb.addAnalyzer(PatternFinderAnalyzer.class).addInputColumn(inputColumn);
            }
            ++columnCount;
        }
    }
}

