/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.DelegateFileObject;
import org.apache.http.client.HttpClient;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.JaxbJobMetadataFactory;
import org.eobjects.analyzer.job.JaxbJobMetadataFactoryImpl;
import org.eobjects.analyzer.job.JaxbJobWriter;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.Main;
import org.eobjects.datacleaner.actions.PublishJobToMonitorActionListener;
import org.eobjects.datacleaner.user.MonitorConnection;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCFileChooser;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;
import org.eobjects.datacleaner.windows.MonitorConnectionDialog;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SaveAnalysisJobActionListener
implements ActionListener {
    public static final String ACTION_COMMAND_SAVE_AS = "SAVE_AS";
    private static final Logger logger = LoggerFactory.getLogger(SaveAnalysisJobActionListener.class);
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final AnalysisJobBuilderWindow _window;
    private final UserPreferences _userPreferences;
    private final UsageLogger _usageLogger;
    private final AnalyzerBeansConfiguration _configuration;
    private final HttpClient _httpClient;

    @Inject
    protected SaveAnalysisJobActionListener(AnalysisJobBuilderWindow window, AnalysisJobBuilder analysisJobBuilder, UserPreferences userPreferences, UsageLogger usageLogger, AnalyzerBeansConfiguration configuration, HttpClient httpClient) {
        this._window = window;
        this._analysisJobBuilder = analysisJobBuilder;
        this._userPreferences = userPreferences;
        this._usageLogger = usageLogger;
        this._configuration = configuration;
        this._httpClient = httpClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        FileObject file;
        String actionCommand = event.getActionCommand();
        this._usageLogger.log("Save analysis job");
        this._window.setStatusLabelNotice();
        this._window.setStatusLabelText("Saving job...");
        AnalysisJob analysisJob = null;
        try {
            this._window.applyPropertyValues();
            analysisJob = this._analysisJobBuilder.toAnalysisJob();
        }
        catch (Exception e) {
            WidgetUtils.showErrorMessage("Errors in job", "Please fix the errors that exist in the job before saving it:\n\n" + this._window.getStatusLabelText(), e);
            return;
        }
        FileObject existingFile = this._window.getJobFile();
        if (existingFile == null || ACTION_COMMAND_SAVE_AS.equals(actionCommand)) {
            int overwrite;
            boolean exists;
            DCFileChooser fileChooser = new DCFileChooser(this._userPreferences.getAnalysisJobDirectory());
            fileChooser.setFileFilter(FileFilters.ANALYSIS_XML);
            int result = fileChooser.showSaveDialog(this._window.toComponent());
            if (result != 0) {
                return;
            }
            FileObject candidate = fileChooser.getSelectedFileObject();
            try {
                String baseName = candidate.getName().getBaseName();
                if (!baseName.endsWith(".xml")) {
                    FileObject parent = candidate.getParent();
                    file = parent.resolveFile(baseName + FileFilters.ANALYSIS_XML.getExtension());
                } else {
                    file = candidate;
                }
                exists = file.exists();
            }
            catch (FileSystemException e) {
                throw new IllegalStateException("Failed to prepare file for saving", e);
            }
            if (exists && (overwrite = JOptionPane.showConfirmDialog(this._window.toComponent(), "Are you sure you want to overwrite the file '" + file.getName() + "'?", "Overwrite existing file?", 0)) != 0) {
                return;
            }
        } else {
            file = existingFile;
        }
        try {
            FileObject parent = file.getParent();
            File parentFile = VFSUtils.toFile((FileObject)parent);
            if (parentFile != null) {
                this._userPreferences.setAnalysisJobDirectory(parentFile);
            }
        }
        catch (FileSystemException e) {
            logger.warn("Failed to determine parent of {}: {}", (Object)file, (Object)e.getMessage());
        }
        String author = this._userPreferences.getUsername();
        String jobName = null;
        String jobDescription = "Created with DataCleaner " + Main.VERSION;
        String jobVersion = null;
        JaxbJobWriter writer = new JaxbJobWriter(this._configuration, (JaxbJobMetadataFactory)new JaxbJobMetadataFactoryImpl(author, jobName, jobDescription, jobVersion));
        OutputStream outputStream = null;
        try {
            outputStream = file.getContent().getOutputStream();
            writer.write(analysisJob, outputStream);
        }
        catch (IOException e1) {
            try {
                throw new IllegalStateException(e1);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{outputStream});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{outputStream});
        if (file instanceof DelegateFileObject) {
            DelegateFileObject delegateFileObject = (DelegateFileObject)file;
            String scheme = file.getName().getScheme();
            if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) throw new UnsupportedOperationException("Unexpected delegate file object: " + delegateFileObject + " (delegate: " + delegateFileObject.getDelegateFile() + ")");
            String uri = delegateFileObject.getName().getURI();
            MonitorConnection monitorConnection = this._userPreferences.getMonitorConnection();
            if (monitorConnection.matchesURI(uri) && monitorConnection.isAuthenticationEnabled() && monitorConnection.getEncodedPassword() == null) {
                MonitorConnectionDialog dialog = new MonitorConnectionDialog(this._window.getWindowContext(), this._userPreferences, this._httpClient);
                dialog.openBlocking();
            }
            PublishJobToMonitorActionListener publisher = new PublishJobToMonitorActionListener(delegateFileObject, this._window.getWindowContext(), this._userPreferences, this._httpClient);
            publisher.actionPerformed(event);
        } else {
            this._userPreferences.addRecentJobFile(file);
        }
        this._window.setJobFile(file);
        this._window.setStatusLabelNotice();
        this._window.setStatusLabelText("Saved job to file " + file.getName().getBaseName());
    }
}

