/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.JOptionPane;
import org.apache.commons.lang.SerializationUtils;
import org.eobjects.analyzer.result.AnalysisResult;
import org.eobjects.analyzer.result.SimpleAnalysisResult;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCFileChooser;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveAnalysisResultActionListener
implements ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(SaveAnalysisResultActionListener.class);
    private final Ref<AnalysisResult> _result;
    private final UserPreferences _userPreferences;

    public SaveAnalysisResultActionListener(Ref<AnalysisResult> result, UserPreferences userPreferences) {
        this._result = result;
        this._userPreferences = userPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        if (this._result.get() == null) {
            WidgetUtils.showErrorMessage("Result not ready", "Please wait for the job to finish before saving the result", null);
            return;
        }
        DCFileChooser fileChooser = new DCFileChooser(this._userPreferences.getAnalysisJobDirectory());
        fileChooser.setFileFilter(FileFilters.ANALYSIS_RESULT_SER);
        Component parent = event.getSource() instanceof Component ? (Component)event.getSource() : null;
        int result = fileChooser.showSaveDialog(parent);
        if (result == 0) {
            int overwrite;
            File file = fileChooser.getSelectedFile();
            if (!file.getName().endsWith(FileFilters.ANALYSIS_RESULT_SER.getExtension())) {
                file = new File(file.getParentFile(), file.getName() + FileFilters.ANALYSIS_RESULT_SER.getExtension());
            }
            if (file.exists() && (overwrite = JOptionPane.showConfirmDialog(parent, "Are you sure you want to overwrite the file '" + file.getName() + "'?", "Overwrite existing file?", 0)) != 0) {
                return;
            }
            this._userPreferences.setAnalysisJobDirectory(file.getParentFile());
            SimpleAnalysisResult analysisResult = this._result instanceof SimpleAnalysisResult ? (SimpleAnalysisResult)this._result : new SimpleAnalysisResult(((AnalysisResult)this._result.get()).getResultMap());
            OutputStream out = FileHelper.getOutputStream((File)file);
            try {
                SerializationUtils.serialize((Serializable)analysisResult, (OutputStream)out);
            }
            catch (Exception e) {
                try {
                    logger.error("Error serializing analysis result: " + analysisResult, (Throwable)e);
                    WidgetUtils.showErrorMessage("Error writing result to file", e);
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{out});
                    throw throwable;
                }
                FileHelper.safeClose((Object[])new Object[]{out});
            }
            FileHelper.safeClose((Object[])new Object[]{out});
        }
    }
}

