/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.datacleaner.output.OutputRow;
import org.eobjects.datacleaner.output.OutputWriter;
import org.eobjects.datacleaner.output.csv.CsvOutputWriterFactory;
import org.eobjects.datacleaner.output.datastore.DatastoreCreationDelegate;
import org.eobjects.datacleaner.output.datastore.DatastoreCreationDelegateImpl;
import org.eobjects.datacleaner.output.datastore.DatastoreOutputWriterFactory;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.widgets.DCFileChooser;

public class SaveDataSetActionListener
implements ActionListener {
    private final List<InputColumn<?>> _inputColumns;
    private final InputRow[] _rows;
    private final UserPreferences _userPreferences;
    private final DatastoreCatalog _datastoreCatalog;
    private final UsageLogger _usageLogger;

    public SaveDataSetActionListener(List<InputColumn<?>> inputColumns, InputRow[] rows, UserPreferences userPreferences, DatastoreCatalog datastoreCatalog, UsageLogger usageLogger) {
        this._inputColumns = inputColumns;
        this._rows = rows;
        this._userPreferences = userPreferences;
        this._datastoreCatalog = datastoreCatalog;
        this._usageLogger = usageLogger;
    }

    private void performWrite(OutputWriter writer) {
        for (InputRow row : this._rows) {
            OutputRow outputRow = writer.createRow();
            outputRow.setValues(row);
            outputRow.write();
        }
        writer.close();
    }

    @Override
    public void actionPerformed(final ActionEvent event) {
        JMenuItem saveAsDatastoreItem = new JMenuItem("As datastore");
        saveAsDatastoreItem.setIcon(IconUtils.getDatastoreIcon(null));
        saveAsDatastoreItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String datastoreName = JOptionPane.showInputDialog("Datastore name");
                DatastoreCreationDelegateImpl creationDelegate = new DatastoreCreationDelegateImpl((MutableDatastoreCatalog)SaveDataSetActionListener.this._datastoreCatalog);
                OutputWriter writer = DatastoreOutputWriterFactory.getWriter(SaveDataSetActionListener.this._userPreferences.getSaveDatastoreDirectory(), (DatastoreCreationDelegate)creationDelegate, datastoreName, "DATASET", SaveDataSetActionListener.this._inputColumns.toArray(new InputColumn[0]));
                SaveDataSetActionListener.this.performWrite(writer);
                SaveDataSetActionListener.this._usageLogger.log("Save DataSet as datastore");
            }
        });
        JMenuItem saveAsCsvItem = new JMenuItem("As CSV file");
        saveAsCsvItem.setIcon(ImageManager.getInstance().getImageIcon("images/datastore-types/csv.png", new ClassLoader[0]));
        saveAsCsvItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DCFileChooser fileChooser = new DCFileChooser(SaveDataSetActionListener.this._userPreferences.getAnalysisJobDirectory());
                fileChooser.addChoosableFileFilter(FileFilters.CSV);
                if (fileChooser.showSaveDialog((Component)event.getSource()) == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    if (selectedFile.getName().indexOf(46) == -1) {
                        selectedFile = new File(selectedFile.getPath() + ".csv");
                    }
                    OutputWriter writer = CsvOutputWriterFactory.getWriter(selectedFile.getAbsolutePath(), SaveDataSetActionListener.this._inputColumns);
                    SaveDataSetActionListener.this.performWrite(writer);
                    File dir = selectedFile.getParentFile();
                    SaveDataSetActionListener.this._userPreferences.setAnalysisJobDirectory(dir);
                    SaveDataSetActionListener.this._usageLogger.log("Save DataSet as CSV file");
                }
            }
        });
        JPopupMenu popup = new JPopupMenu();
        popup.add(saveAsDatastoreItem);
        popup.add(saveAsCsvItem);
        JComponent source = (JComponent)event.getSource();
        popup.show(source, 0, source.getHeight());
    }
}

