/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.DCModule;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.output.beans.CreateExcelSpreadsheetAnalyzer;
import org.eobjects.datacleaner.panels.AnalyzerJobBuilderPanel;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPane;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.datacleaner.windows.ResultWindow;
import org.eobjects.metamodel.schema.Table;

public final class SaveTableAsExcelSpreadsheetActionListener
implements ActionListener {
    private final Datastore _datastore;
    private final Table _table;
    private final WindowContext _windowContext;
    private final AnalyzerBeansConfiguration _configuration;
    private final DCModule _parentModule;
    private final UserPreferences _userPreferences;
    private final InjectorBuilder _injectorBuilder;

    @Inject
    protected SaveTableAsExcelSpreadsheetActionListener(Datastore datastore, Table table, WindowContext windowContext, AnalyzerBeansConfiguration configuration, UserPreferences userPreferences, DCModule parentModule, InjectorBuilder injectorBuilder) {
        this._datastore = datastore;
        this._table = table;
        this._windowContext = windowContext;
        this._configuration = configuration;
        this._parentModule = parentModule;
        this._userPreferences = userPreferences;
        this._injectorBuilder = injectorBuilder;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final AnalysisJobBuilder ajb = new AnalysisJobBuilder(this._configuration);
        ajb.setDatastore(this._datastore);
        ajb.addSourceColumns(this._table.getColumns());
        final AnalyzerJobBuilder excelOutputAnalyzerBuilder = ajb.addAnalyzer(CreateExcelSpreadsheetAnalyzer.class);
        excelOutputAnalyzerBuilder.addInputColumns((Collection)ajb.getSourceColumns());
        File directory = this._userPreferences.getConfiguredFileDirectory();
        ((CreateExcelSpreadsheetAnalyzer)excelOutputAnalyzerBuilder.getConfigurableBean()).setFile(new File(directory, this._datastore.getName() + ".xlsx"));
        ((CreateExcelSpreadsheetAnalyzer)excelOutputAnalyzerBuilder.getConfigurableBean()).setSheetName(this._table.getName());
        PropertyWidgetFactory propertyWidgetFactory = this._injectorBuilder.with(PropertyWidgetFactory.TYPELITERAL_BEAN_JOB_BUILDER, (Object)excelOutputAnalyzerBuilder).getInstance(PropertyWidgetFactory.class);
        final AnalyzerJobBuilderPanel presenter = new AnalyzerJobBuilderPanel(excelOutputAnalyzerBuilder, false, propertyWidgetFactory);
        final AbstractDialog dialog = new AbstractDialog(this._windowContext){
            private static final long serialVersionUID = 1L;

            @Override
            public String getWindowTitle() {
                return "Save " + SaveTableAsExcelSpreadsheetActionListener.this._table.getName() + " as Excel spreadsheet";
            }

            @Override
            protected int getDialogWidth() {
                return 600;
            }

            @Override
            protected JComponent getDialogContent() {
                AnalyzerBeanDescriptor descriptor = (AnalyzerBeanDescriptor)excelOutputAnalyzerBuilder.getDescriptor();
                CloseableTabbedPane tabbedPane = new CloseableTabbedPane(true);
                tabbedPane.addTab(descriptor.getDisplayName(), IconUtils.getDescriptorIcon(descriptor, IconUtils.ICON_SIZE_LARGE), presenter.createJComponent());
                tabbedPane.setUnclosableTab(0);
                return tabbedPane;
            }

            @Override
            protected String getBannerTitle() {
                return "Save " + SaveTableAsExcelSpreadsheetActionListener.this._table.getName() + "\nas Excel spreadsheet file";
            }
        };
        JButton runButton = new JButton("Run", ImageManager.getInstance().getImageIcon("images/actions/execute.png", new ClassLoader[0]));
        runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Injector injector = Guice.createInjector((Module[])new Module[]{new DCModule(SaveTableAsExcelSpreadsheetActionListener.this._parentModule, ajb)});
                ResultWindow window = (ResultWindow)injector.getInstance(ResultWindow.class);
                window.setVisible(true);
                dialog.dispose();
                window.startAnalysis();
            }
        });
        presenter.addToButtonPanel(runButton);
        dialog.setVisible(true);
    }
}

