/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JMenuItem;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.descriptors.DescriptorProvider;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.widgets.DescriptorMenuItem;
import org.eobjects.datacleaner.widgets.DescriptorPopupMenu;
import org.eobjects.metamodel.util.CollectionUtils;

public final class TransformButtonActionListener
implements ActionListener {
    private final AnalyzerBeansConfiguration _configuration;
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final UsageLogger _usageLogger;

    @Inject
    protected TransformButtonActionListener(AnalyzerBeansConfiguration configuration, AnalysisJobBuilder analysisJobBuilder, UsageLogger usageLogger) {
        this._configuration = configuration;
        this._analysisJobBuilder = analysisJobBuilder;
        this._usageLogger = usageLogger;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DescriptorProvider descriptorProvider = this._configuration.getDescriptorProvider();
        Collection filterBeanDescriptors = descriptorProvider.getFilterBeanDescriptors();
        Collection transformerBeanDescritpors = descriptorProvider.getTransformerBeanDescriptors();
        List descriptors = CollectionUtils.concat((boolean)false, (Collection)filterBeanDescriptors, (Collection[])new Collection[]{transformerBeanDescritpors});
        DescriptorPopupMenu popup = new DescriptorPopupMenu<BeanDescriptor<?>>(descriptors){
            private static final long serialVersionUID = 1L;

            @Override
            protected JMenuItem createMenuItem(final BeanDescriptor<?> descriptor) {
                DescriptorMenuItem menuItem = new DescriptorMenuItem(descriptor);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (descriptor instanceof TransformerBeanDescriptor) {
                            TransformButtonActionListener.this._analysisJobBuilder.addTransformer((TransformerBeanDescriptor)descriptor);
                            TransformButtonActionListener.this._usageLogger.log("Add transformer: " + descriptor.getDisplayName());
                        } else if (descriptor instanceof FilterBeanDescriptor) {
                            TransformButtonActionListener.this._analysisJobBuilder.addFilter((FilterBeanDescriptor)descriptor);
                            TransformButtonActionListener.this._usageLogger.log("Add filter: " + descriptor.getDisplayName());
                        }
                    }
                });
                return menuItem;
            }
        };
        Component source = (Component)e.getSource();
        popup.show(source, 0, source.getHeight());
    }
}

