/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.bootstrap;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.SplashScreen;
import java.io.Closeable;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.SwingUtilities;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.DelegateFileObject;
import org.apache.commons.vfs2.provider.url.UrlFileName;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eobjects.analyzer.cli.CliArguments;
import org.eobjects.analyzer.cli.CliRunner;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.Main;
import org.eobjects.datacleaner.actions.DownloadFilesActionListener;
import org.eobjects.datacleaner.actions.OpenAnalysisJobActionListener;
import org.eobjects.datacleaner.bootstrap.BootstrapOptions;
import org.eobjects.datacleaner.bootstrap.ExitActionListener;
import org.eobjects.datacleaner.bootstrap.SimpleWindowContext;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.extensionswap.ExtensionSwapClient;
import org.eobjects.datacleaner.extensionswap.ExtensionSwapInstallationHttpContainer;
import org.eobjects.datacleaner.guice.DCModule;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.macos.MacOSManager;
import org.eobjects.datacleaner.regexswap.RegexSwapUserPreferencesHandler;
import org.eobjects.datacleaner.user.DataCleanerHome;
import org.eobjects.datacleaner.user.MonitorConnection;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.user.UserPreferencesImpl;
import org.eobjects.datacleaner.util.DCUncaughtExceptionHandler;
import org.eobjects.datacleaner.util.LookAndFeelManager;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;
import org.eobjects.datacleaner.windows.MonitorConnectionDialog;
import org.eobjects.datacleaner.windows.WelcomeDialog;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Bootstrap {
    private static final Logger logger = LoggerFactory.getLogger(Bootstrap.class);
    private final BootstrapOptions _options;

    public Bootstrap(BootstrapOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Bootstrap options cannot be null");
        }
        this._options = options;
    }

    public void run() {
        try {
            this.runInternal();
        }
        catch (Exception e) {
            logger.error("An unexpected error has occurred during bootstrap. Exiting with status code -2.", (Throwable)e);
            this.exitCommandLine(null, -2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInternal() throws FileSystemException {
        Image welcomeImage;
        Datastore singleDatastore;
        CliArguments arguments;
        boolean cliMode;
        block23: {
            SplashScreen splashScreen;
            logger.info("Welcome to DataCleaner {}", (Object)Main.VERSION);
            cliMode = this._options.isCommandLineMode();
            arguments = this._options.getCommandLineArguments();
            logger.info("CLI mode={}, use -usage to view usage options", (Object)cliMode);
            if (!cliMode) break block23;
            if (!GraphicsEnvironment.isHeadless() && (splashScreen = SplashScreen.getSplashScreen()) != null) {
                splashScreen.close();
            }
            if (!arguments.isUsageMode()) break block23;
            PrintWriter out = new PrintWriter(System.out);
            try {
                CliArguments.printUsage((PrintWriter)out);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{out});
                throw throwable;
            }
            FileHelper.safeClose((Object[])new Object[]{out});
            this.exitCommandLine(null, 1);
            return;
        }
        if (!cliMode) {
            DCUncaughtExceptionHandler exceptionHandler = new DCUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
            LookAndFeelManager.getInstance().init();
        }
        UserPreferencesImpl initialUserPreferences = new UserPreferencesImpl(null);
        String configurationFilePath = arguments.getConfigurationFile();
        FileObject configurationFile = this.resolveFile(configurationFilePath, "conf.xml", initialUserPreferences);
        Injector injector = Guice.createInjector((Module[])new Module[]{new DCModule(DataCleanerHome.get(), configurationFile)});
        AnalyzerBeansConfiguration configuration = (AnalyzerBeansConfiguration)injector.getInstance(AnalyzerBeansConfiguration.class);
        UsageLogger usageLogger = (UsageLogger)injector.getInstance(UsageLogger.class);
        usageLogger.logApplicationStartup();
        if (cliMode) {
            int exitCode = 0;
            CliRunner runner = new CliRunner(arguments);
            try {
                runner.run(configuration);
            }
            catch (Throwable e) {
                logger.error("Error occurred while running DataCleaner command line mode", e);
                exitCode = 1;
            }
            finally {
                runner.close();
                this.exitCommandLine(configuration, exitCode);
            }
            return;
        }
        MacOSManager macOsManager = (MacOSManager)injector.getInstance(MacOSManager.class);
        macOsManager.init();
        String jobFilePath = this._options.getCommandLineArguments().getJobFile();
        if (jobFilePath != null) {
            FileObject jobFile = this.resolveFile(jobFilePath, null, initialUserPreferences);
            injector = OpenAnalysisJobActionListener.open(jobFile, configuration, injector);
        }
        UserPreferences userPreferences = (UserPreferences)injector.getInstance(UserPreferences.class);
        final AnalysisJobBuilderWindow analysisJobBuilderWindow = (AnalysisJobBuilderWindow)injector.getInstance(AnalysisJobBuilderWindow.class);
        if (this._options.isSingleDatastoreMode()) {
            DatastoreCatalog datastoreCatalog = configuration.getDatastoreCatalog();
            singleDatastore = this._options.getSingleDatastore(datastoreCatalog);
            if (singleDatastore == null) {
                logger.info("Single datastore mode was enabled, but datastore was null!");
            } else {
                logger.info("Initializing single datastore mode with {}", (Object)singleDatastore);
            }
            analysisJobBuilderWindow.setDatastoreSelectionEnabled(false);
            analysisJobBuilderWindow.setDatastore(singleDatastore, true);
        } else {
            singleDatastore = null;
        }
        analysisJobBuilderWindow.open();
        if (singleDatastore != null) {
            AnalysisJobBuilder analysisJobBuilder = analysisJobBuilderWindow.getAnalysisJobBuilder();
            DatastoreConnection con = singleDatastore.openConnection();
            InjectorBuilder injectorBuilder = (InjectorBuilder)injector.getInstance(InjectorBuilder.class);
            try {
                this._options.initializeSingleDatastoreJob(analysisJobBuilder, con.getDataContext(), injectorBuilder);
            }
            finally {
                con.close();
            }
        }
        if ((welcomeImage = this._options.getWelcomeImage()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WelcomeDialog welcomeDialog = new WelcomeDialog(analysisJobBuilderWindow, welcomeImage);
                    welcomeDialog.setVisible(true);
                }
            });
        }
        WindowContext windowContext = (WindowContext)injector.getInstance(WindowContext.class);
        HttpClient httpClient = (HttpClient)injector.getInstance(HttpClient.class);
        this.loadExtensionSwapService(userPreferences, windowContext, configuration, httpClient, usageLogger);
        RegexSwapUserPreferencesHandler regexSwapHandler = new RegexSwapUserPreferencesHandler((MutableReferenceDataCatalog)configuration.getReferenceDataCatalog(), httpClient, usageLogger);
        userPreferences.addLoginChangeListener(regexSwapHandler);
        ExitActionListener exitActionListener = this._options.getExitActionListener();
        if (exitActionListener != null) {
            windowContext.addExitActionListener(exitActionListener);
        }
    }

    private FileObject resolveFile(String userRequestedFilename, String localFilename, UserPreferences userPreferences) throws FileSystemException {
        FileObject dataCleanerHome = DataCleanerHome.get();
        if (userRequestedFilename == null) {
            return dataCleanerHome.resolveFile(localFilename);
        }
        String lowerCaseFilename = userRequestedFilename.toLowerCase();
        if ((lowerCaseFilename.startsWith("http://") || lowerCaseFilename.startsWith("https://")) && !GraphicsEnvironment.isHeadless()) {
            MonitorConnection monitorConnection;
            URI uri;
            FileObject targetDirectory = VFSUtils.getFileSystemManager().resolveFile("ram:///datacleaner/temp");
            if (!targetDirectory.exists()) {
                targetDirectory.createFolder();
            }
            try {
                uri = new URI(userRequestedFilename);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Illegal URI: " + userRequestedFilename, e);
            }
            DefaultHttpClient httpClient = new DefaultHttpClient();
            SimpleWindowContext windowContext = new SimpleWindowContext();
            if (userPreferences != null && userPreferences.getMonitorConnection() != null && (monitorConnection = userPreferences.getMonitorConnection()).matchesURI(uri)) {
                if (monitorConnection.isAuthenticationEnabled() && monitorConnection.getEncodedPassword() == null) {
                    MonitorConnectionDialog dialog = new MonitorConnectionDialog(windowContext, userPreferences, (HttpClient)httpClient);
                    dialog.openBlocking();
                    monitorConnection = userPreferences.getMonitorConnection();
                }
                monitorConnection.prepareClient((HttpClient)httpClient);
            }
            String[] urls = new String[]{userRequestedFilename};
            String[] targetFilenames = DownloadFilesActionListener.createTargetFilenames(urls);
            DownloadFilesActionListener downloadAction = new DownloadFilesActionListener(urls, targetDirectory, targetFilenames, null, windowContext, (HttpClient)httpClient);
            downloadAction.actionPerformed(null);
            FileObject[] files = downloadAction.getFiles();
            assert (files.length == 1);
            FileObject ramFile = files[0];
            String scheme = uri.getScheme();
            int defaultPort = "http".equals(scheme) ? 80 : 8443;
            UrlFileName fileName = new UrlFileName(scheme, uri.getHost(), uri.getPort(), defaultPort, null, null, uri.getPath(), FileType.FILE, uri.getQuery());
            AbstractFileSystem fileSystem = (AbstractFileSystem)dataCleanerHome.getFileSystem();
            return new DelegateFileObject((AbstractFileName)fileName, fileSystem, ramFile);
        }
        return VFSUtils.getFileSystemManager().resolveFile(userRequestedFilename);
    }

    private void exitCommandLine(AnalyzerBeansConfiguration configuration, int statusCode) {
        ExitActionListener exitActionListener;
        if (configuration != null) {
            logger.debug("Shutting down task runner");
            try {
                configuration.getTaskRunner().shutdown();
            }
            catch (Exception e) {
                logger.warn("Shutting down TaskRunner threw unexpected exception", (Throwable)e);
            }
        }
        if ((exitActionListener = this._options.getExitActionListener()) != null) {
            exitActionListener.exit(statusCode);
        }
    }

    private void loadExtensionSwapService(UserPreferences userPreferences, WindowContext windowContext, AnalyzerBeansConfiguration configuration, HttpClient httpClient, UsageLogger usageLogger) {
        ExtensionSwapClient extensionSwapClient;
        String websiteHostname = userPreferences.getAdditionalProperties().get("extensionswap.hostname");
        if (StringUtils.isNullOrEmpty((String)websiteHostname)) {
            websiteHostname = System.getProperty("extensionswap.hostname");
        }
        if (StringUtils.isNullOrEmpty((String)websiteHostname)) {
            logger.info("Using default ExtensionSwap website hostname");
            extensionSwapClient = new ExtensionSwapClient(httpClient, windowContext, userPreferences, configuration);
        } else {
            logger.info("Using custom ExtensionSwap website hostname: {}", (Object)websiteHostname);
            extensionSwapClient = new ExtensionSwapClient(httpClient, websiteHostname, windowContext, userPreferences, configuration);
        }
        ExtensionSwapInstallationHttpContainer container = new ExtensionSwapInstallationHttpContainer(extensionSwapClient, userPreferences, usageLogger);
        final Closeable closeableConnection = container.initialize();
        if (closeableConnection != null) {
            windowContext.addExitActionListener(new ExitActionListener(){

                @Override
                public void exit(int statusCode) {
                    FileHelper.safeClose((Object[])new Object[]{closeableConnection});
                }
            });
        }
    }
}

