/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.bootstrap;

import org.eobjects.datacleaner.bootstrap.ExitActionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DCExitActionListener
implements ExitActionListener {
    private static final Logger logger = LoggerFactory.getLogger(DCExitActionListener.class);

    DCExitActionListener() {
    }

    @Override
    public void exit(final int statusCode) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (logger.isWarnEnabled()) {
                    logger.warn("Some threads are still running:");
                    ThreadGroup topLevelThreadGroup = null;
                    for (ThreadGroup threadGroup = Thread.currentThread().getThreadGroup(); threadGroup != null; threadGroup = threadGroup.getParent()) {
                        topLevelThreadGroup = threadGroup;
                    }
                    DCExitActionListener.printThreadInformation(topLevelThreadGroup, "");
                    logger.warn("Invoking system.exit({})", (Object)statusCode);
                }
                System.exit(statusCode);
            }
        };
        thread.setDaemon(true);
        logger.info("Scheduling shutdown thread");
        thread.start();
    }

    public static void printThreadInformation(ThreadGroup threadGroup, String prefix) {
        logger.warn("Thread group: " + threadGroup);
        ThreadGroup[] groups = new ThreadGroup[threadGroup.activeGroupCount() + 2];
        int groupCount = threadGroup.enumerate(groups);
        for (int i = 0; i < groupCount; ++i) {
            ThreadGroup group = groups[i];
            DCExitActionListener.printThreadInformation(group, prefix + "  ");
        }
        Thread[] threads = new Thread[threadGroup.activeCount() + 4];
        int threadCount = threadGroup.enumerate(threads);
        for (int i = 0; i < threadCount; ++i) {
            Thread thread = threads[i];
            if (thread == null) continue;
            boolean alive = thread.isAlive();
            boolean daemon = thread.isDaemon();
            logger.warn(prefix + "thread #" + (i + 1) + " (" + (alive ? "alive" : "dead") + (daemon ? ",daemon" : "") + ")" + ": " + thread);
            if (!alive || daemon) continue;
            StackTraceElement[] stackTrace = thread.getStackTrace();
            for (int j = stackTrace.length - 1; j >= 0; --j) {
                logger.warn(prefix + " | stack " + (j + 1) + ": " + stackTrace[j]);
            }
        }
    }
}

