/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.bootstrap;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.datacleaner.bootstrap.ExitActionListener;
import org.eobjects.datacleaner.bootstrap.SimpleWindowContext;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.windows.DCWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DCWindowContext
extends SimpleWindowContext
implements WindowContext {
    private static final Logger logger = LoggerFactory.getLogger(DCWindowContext.class);
    private static final List<WeakReference<DCWindowContext>> _allWindowContexts = new ArrayList<WeakReference<DCWindowContext>>();
    private final List<ActionListener> _windowListeners = new ArrayList<ActionListener>();
    private final List<ExitActionListener> _exitActionListeners = new ArrayList<ExitActionListener>();
    private final AnalyzerBeansConfiguration _configuration;
    private final UserPreferences _userPreferences;
    private boolean _exiting;
    private UsageLogger _usageLogger;

    public static DCWindow getAnyWindow() {
        for (WeakReference<DCWindowContext> ref : _allWindowContexts) {
            DCWindowContext windowContext = (DCWindowContext)ref.get();
            if (windowContext == null) continue;
            List<DCWindow> windows = windowContext.getWindows();
            for (DCWindow window : windows) {
                if (window == null) continue;
                return window;
            }
        }
        return null;
    }

    public DCWindowContext(AnalyzerBeansConfiguration configuration, UserPreferences userPreferences, UsageLogger usageLogger) {
        this._configuration = configuration;
        this._userPreferences = userPreferences;
        this._usageLogger = usageLogger;
        _allWindowContexts.add(new WeakReference<DCWindowContext>(this));
        this._exiting = false;
    }

    @Override
    public void addWindowListener(ActionListener listener) {
        this._windowListeners.add(listener);
    }

    @Override
    public void removeWindowListener(ActionListener listener) {
        this._windowListeners.remove(listener);
    }

    @Override
    public void onDispose(DCWindow window) {
        super.onDispose(window);
        this.notifyListeners();
        if (!this._exiting && this.getWindows().isEmpty()) {
            logger.info("All DataCleaner windows closed");
            this.exit();
        }
    }

    private void notifyListeners() {
        ActionEvent event = new ActionEvent(this, this.getWindows().size(), null);
        for (ActionListener listener : this._windowListeners) {
            listener.actionPerformed(event);
        }
    }

    @Override
    public void onShow(DCWindow window) {
        super.onShow(window);
        this.notifyListeners();
    }

    @Override
    public boolean showExitDialog() {
        int confirmation = JOptionPane.showConfirmDialog(null, "Are you sure you want to exit DataCleaner?", "Exit", 2);
        return confirmation == 0;
    }

    @Override
    public void exit() {
        if (this._exiting) {
            return;
        }
        this._exiting = true;
        this._userPreferences.save();
        this._usageLogger.logApplicationShutdown();
        if (this._configuration != null) {
            this._configuration.getTaskRunner().shutdown();
        }
        for (ExitActionListener actionListener : this._exitActionListeners) {
            actionListener.exit(0);
        }
        ArrayList<DCWindow> windowsCopy = new ArrayList<DCWindow>(this.getWindows());
        for (DCWindow window : windowsCopy) {
            window.close();
        }
    }

    @Override
    public void addExitActionListener(ExitActionListener exitActionListener) {
        this._exitActionListeners.add(exitActionListener);
    }

    @Override
    public void removeExitActionListener(ExitActionListener exitActionListener) {
        this._exitActionListeners.remove(exitActionListener);
    }
}

