/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.bootstrap;

import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;
import org.eobjects.analyzer.cli.CliArguments;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.bootstrap.BootstrapOptions;
import org.eobjects.datacleaner.bootstrap.DCExitActionListener;
import org.eobjects.datacleaner.bootstrap.ExitActionListener;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.util.ResourceManager;
import org.eobjects.metamodel.DataContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBootstrapOptions
implements BootstrapOptions {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBootstrapOptions.class);
    private final String[] _args;
    private final CliArguments _arguments;
    private final boolean _commandLineMode;
    private final String _embeddedClientName;

    public DefaultBootstrapOptions(String[] args) {
        this._args = args;
        this._arguments = CliArguments.parse((String[])this._args);
        boolean commandLineMode = this._arguments.isSet();
        if (commandLineMode && "true".equalsIgnoreCase(System.getProperty("datacleaner.ui.visible", "false"))) {
            commandLineMode = false;
        }
        this._commandLineMode = commandLineMode;
        this._embeddedClientName = System.getProperty("datacleaner.embed.client");
    }

    @Override
    public boolean isCommandLineMode() {
        return this._commandLineMode;
    }

    @Override
    public CliArguments getCommandLineArguments() {
        return this._arguments;
    }

    @Override
    public ExitActionListener getExitActionListener() {
        return new DCExitActionListener();
    }

    @Override
    public boolean isSingleDatastoreMode() {
        return this._arguments.getDatastoreName() != null;
    }

    @Override
    public Datastore getSingleDatastore(DatastoreCatalog datastoreCatalog) {
        String ds = this._arguments.getDatastoreName();
        return datastoreCatalog.getDatastore(ds);
    }

    @Override
    public void initializeSingleDatastoreJob(AnalysisJobBuilder analysisJobBuilder, DataContext dataContext, InjectorBuilder injectorBuilder) {
    }

    @Override
    public Image getWelcomeImage() {
        if (this._arguments.getJobFile() != null && "Kettle".equals(this._embeddedClientName)) {
            try {
                URL url = ResourceManager.getInstance().getUrl("images/pdi_dc_banner.png", new ClassLoader[0]);
                return ImageIO.read(url);
            }
            catch (Exception e) {
                logger.warn("Could not load PDI DC banner", (Throwable)e);
            }
        }
        return null;
    }
}

