/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.extensionswap;

import java.io.File;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.http.client.HttpClient;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.actions.DownloadFilesActionListener;
import org.eobjects.datacleaner.actions.FileDownloadListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.extensionswap.ExtensionSwapPackage;
import org.eobjects.datacleaner.user.ExtensionPackage;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.HttpXmlUtils;
import org.w3c.dom.Element;

public final class ExtensionSwapClient {
    public static final String DEFAULT_WEBSITE_HOSTNAME = "datacleaner.org";
    private static final String EXTENSIONSWAP_ID_PROPERTY = "extensionswap.id";
    private static final String EXTENSIONSWAP_VERSION_PROPERTY = "extensionswap.version";
    private final HttpClient _httpClient;
    private final WindowContext _windowContext;
    private final String _baseUrl;
    private final UserPreferences _userPreferences;
    private final AnalyzerBeansConfiguration _configuration;

    public ExtensionSwapClient(HttpClient httpClient, WindowContext windowContext, UserPreferences userPreferences, AnalyzerBeansConfiguration configuration) {
        this(DEFAULT_WEBSITE_HOSTNAME, windowContext, userPreferences, configuration, httpClient);
    }

    public ExtensionSwapClient(String websiteHostname, WindowContext windowContext, UserPreferences userPreferences, AnalyzerBeansConfiguration configuration, HttpClient httpClient) {
        this(httpClient, websiteHostname, windowContext, userPreferences, configuration);
    }

    public ExtensionSwapClient(HttpClient httpClient, String websiteHostname, WindowContext windowContext, UserPreferences userPreferences, AnalyzerBeansConfiguration configuration) {
        this._httpClient = httpClient;
        this._windowContext = windowContext;
        this._baseUrl = "http://" + websiteHostname + "/ws/extension/";
        this._userPreferences = userPreferences;
        this._configuration = configuration;
    }

    public ExtensionPackage registerExtensionPackage(ExtensionSwapPackage extensionSwapPackage, File jarFile) {
        String packageName = extensionSwapPackage.getPackageName();
        if (packageName == null) {
            packageName = ExtensionPackage.autoDetectPackageName(jarFile);
        }
        ExtensionPackage extensionPackage = new ExtensionPackage(extensionSwapPackage.getName(), packageName, true, new File[]{jarFile});
        extensionPackage.getAdditionalProperties().put(EXTENSIONSWAP_ID_PROPERTY, extensionSwapPackage.getId());
        extensionPackage.getAdditionalProperties().put(EXTENSIONSWAP_VERSION_PROPERTY, Integer.toString(extensionSwapPackage.getVersion()));
        extensionPackage.loadDescriptors(this._configuration.getDescriptorProvider());
        this._userPreferences.getExtensionPackages().add(extensionPackage);
        return extensionPackage;
    }

    public ExtensionSwapPackage getExtensionSwapPackage(String id) {
        Element rootNode = HttpXmlUtils.getRootNode(this._httpClient, this._baseUrl + id);
        String name = HttpXmlUtils.getChildNodeText(rootNode, "name");
        int version = Integer.parseInt(HttpXmlUtils.getChildNodeText(rootNode, "version"));
        String packageName = HttpXmlUtils.getChildNodeText(rootNode, "package");
        return new ExtensionSwapPackage(id, version, name, packageName);
    }

    public void registerExtensionPackage(final ExtensionSwapPackage extensionSwapPackage, String username) {
        this.downloadJarFile(extensionSwapPackage, username, new FileDownloadListener(){

            @Override
            public void onFilesDownloaded(FileObject[] files) {
                File jarFile = VFSUtils.toFile((FileObject)files[0]);
                ExtensionSwapClient.this.registerExtensionPackage(extensionSwapPackage, jarFile);
            }
        });
    }

    private void downloadJarFile(ExtensionSwapPackage extensionSwapPackage, String username, FileDownloadListener listener) {
        String url = this._baseUrl + extensionSwapPackage.getId() + "/jarfile";
        if (!StringUtils.isNullOrEmpty((String)username)) {
            url = url + "?username=" + username;
        }
        String filename = extensionSwapPackage.getId() + ".jar";
        DownloadFilesActionListener actionListener = new DownloadFilesActionListener(new String[]{url}, new String[]{filename}, listener, this._windowContext, this._httpClient, this._userPreferences);
        actionListener.actionPerformed(null);
    }

    public boolean isInstalled(ExtensionSwapPackage extensionSwapPackage) {
        List<ExtensionPackage> extensionPackages = this._userPreferences.getExtensionPackages();
        for (ExtensionPackage extensionPackage : extensionPackages) {
            String id = extensionPackage.getAdditionalProperties().get(EXTENSIONSWAP_ID_PROPERTY);
            if (!extensionSwapPackage.getId().equals(id)) continue;
            return true;
        }
        return false;
    }
}

