/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.extensionswap;

import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.eobjects.datacleaner.bootstrap.DCWindowContext;
import org.eobjects.datacleaner.extensionswap.ExtensionSwapClient;
import org.eobjects.datacleaner.extensionswap.ExtensionSwapPackage;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.InvalidHttpResponseException;
import org.eobjects.metamodel.util.FileHelper;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionSwapInstallationHttpContainer
implements Container {
    private static final int PORT_NUMBER = 31389;
    private static final Logger logger = LoggerFactory.getLogger(ExtensionSwapInstallationHttpContainer.class);
    private final ExtensionSwapClient _client;
    private final UserPreferences _userPreferences;
    private final UsageLogger _usageLogger;

    public ExtensionSwapInstallationHttpContainer(ExtensionSwapClient extensionSwapClient, UserPreferences userPreferences, UsageLogger usageLogger) {
        this._client = extensionSwapClient;
        this._userPreferences = userPreferences;
        this._usageLogger = usageLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handle(Request req, Response resp) {
        PrintStream out;
        block11: {
            out = null;
            String callback = null;
            try {
                out = resp.getPrintStream();
                callback = req.getParameter("callback");
                String extensionId = req.getParameter("extensionId");
                if (extensionId == null) {
                    throw new IllegalArgumentException("extensionId cannot be null");
                }
                final String username = this._userPreferences.isLoggedIn() ? this._userPreferences.getUsername() : req.getParameter("username");
                logger.info("Initiating transfer of extension: {}", (Object)extensionId);
                final ExtensionSwapPackage extensionSwapPackage = this._client.getExtensionSwapPackage(extensionId);
                logger.info("Fetched ExtensionSwap package: {}", (Object)extensionSwapPackage);
                if (this._client.isInstalled(extensionSwapPackage)) {
                    if (callback != null && out != null) {
                        out.print(callback + "({\"success\":false,\"errorMessage\":\"This extension is already installed\"})");
                    }
                    resp.setCode(500);
                    break block11;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionSwapInstallationHttpContainer.this.displayInstallationOptions(extensionSwapPackage, username);
                    }
                });
                if (callback != null) {
                    out.print(callback + "({\"success\":true})");
                }
                resp.setCode(200);
            }
            catch (InvalidHttpResponseException e) {
                if (callback != null && out != null) {
                    out.print(callback + "({\"success\":false,\"errorMessage\":\"Could not retrieve extension details\"})");
                }
                resp.setCode(500);
                FileHelper.safeClose((Object[])new Object[]{out});
            }
            catch (IOException e2) {
                logger.error("IOException occurred while processing HTTP request", (Throwable)e2);
                resp.setCode(400);
                {
                    catch (Throwable throwable) {
                        FileHelper.safeClose((Object[])new Object[]{out});
                        throw throwable;
                    }
                }
                FileHelper.safeClose((Object[])new Object[]{out});
            }
        }
        FileHelper.safeClose((Object[])new Object[]{out});
    }

    private void displayInstallationOptions(ExtensionSwapPackage extensionSwapPackage, String username) {
        this._usageLogger.log("Extension install: " + extensionSwapPackage.getId());
        String title = "Install DataCleaner extension?";
        String message = "Do you want to download and install the extension '" + extensionSwapPackage.getName() + "'";
        Component window = (Component)((Object)DCWindowContext.getAnyWindow());
        int confirmation = JOptionPane.showConfirmDialog(window, message, "Install DataCleaner extension?", 0);
        if (confirmation == 0) {
            this._client.registerExtensionPackage(extensionSwapPackage, username);
        }
    }

    public Closeable initialize() {
        try {
            SocketConnection connection = new SocketConnection((Container)this);
            InetSocketAddress address = new InetSocketAddress(31389);
            connection.connect((SocketAddress)address);
            logger.info("HTTP service for ExtensionSwap installation running on port {}", (Object)31389);
            return connection;
        }
        catch (IOException e) {
            logger.warn("Could not host HTTP service for ExtensionSwap installation on port 31389. Automatic installations of extensions will not be available.", (Throwable)e);
            return null;
        }
    }
}

