/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Providers;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AdHocModule
implements Module {
    private static final Logger logger = LoggerFactory.getLogger(AdHocModule.class);
    private final Map<TypeLiteral<?>, Object> _bindings = new HashMap();

    public <E> void bind(Class<?> bindingClass, Object providerOrInstance) {
        this.bind(Key.get(bindingClass), providerOrInstance);
    }

    public <E> void bind(Key<?> bindingKey, Object providerOrInstance) {
        this.bind(bindingKey.getTypeLiteral(), providerOrInstance);
    }

    public <E> void bind(TypeLiteral<?> bindingTypeLiteral, Object providerOrInstance) {
        if (providerOrInstance == null) {
            providerOrInstance = Providers.of(null);
        }
        this._bindings.put(bindingTypeLiteral, providerOrInstance);
    }

    public boolean hasBindingFor(TypeLiteral<?> bindingTypeLiteral) {
        return this._bindings.containsKey(bindingTypeLiteral);
    }

    public boolean hasBindingFor(Key<?> bindingKey) {
        return this.hasBindingFor(bindingKey.getTypeLiteral());
    }

    public boolean hasBindingFor(Class<?> bindingClass) {
        return this.hasBindingFor(Key.get(bindingClass));
    }

    public void configure(Binder binder) {
        Set<Map.Entry<TypeLiteral<?>, Object>> entrySet = this._bindings.entrySet();
        for (Map.Entry<TypeLiteral<?>, Object> entry : entrySet) {
            TypeLiteral<?> bindingLiteral = entry.getKey();
            Object providerOrInstance = entry.getValue();
            logger.info("Binding ad-hoc dependency for {}: {}", bindingLiteral, providerOrInstance);
            if (providerOrInstance instanceof Provider) {
                Provider provider = (Provider)providerOrInstance;
                com.google.inject.Provider guiceProvider = Providers.guicify((Provider)provider);
                binder.bind(bindingLiteral).toProvider(guiceProvider);
                continue;
            }
            if (providerOrInstance instanceof com.google.inject.Provider) {
                com.google.inject.Provider guiceProvider = (com.google.inject.Provider)providerOrInstance;
                binder.bind(bindingLiteral).toProvider(guiceProvider);
                continue;
            }
            binder.bind(bindingLiteral).toInstance(providerOrInstance);
        }
    }
}

