/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.http.client.HttpClient;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfigurationImpl;
import org.eobjects.analyzer.configuration.InjectionManager;
import org.eobjects.analyzer.configuration.InjectionManagerFactory;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.descriptors.DescriptorProvider;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.concurrent.TaskRunner;
import org.eobjects.analyzer.job.runner.ReferenceDataActivationManager;
import org.eobjects.analyzer.lifecycle.LifeCycleHelper;
import org.eobjects.analyzer.reference.ReferenceDataCatalog;
import org.eobjects.analyzer.result.AnalysisResult;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.storage.StorageProvider;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.bootstrap.DCWindowContext;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.GuiceInjectionManagerFactory;
import org.eobjects.datacleaner.guice.JobFile;
import org.eobjects.datacleaner.guice.Nullable;
import org.eobjects.datacleaner.guice.Undecorated;
import org.eobjects.datacleaner.user.AuthenticationService;
import org.eobjects.datacleaner.user.DCAuthenticationService;
import org.eobjects.datacleaner.user.DataCleanerConfigurationReader;
import org.eobjects.datacleaner.user.ExtensionPackage;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.user.UserPreferencesImpl;
import org.eobjects.datacleaner.util.HttpXmlUtils;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindowImpl;
import org.eobjects.metamodel.util.ImmutableRef;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.MutableRef;
import org.eobjects.metamodel.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(DCModule.class);
    private final Ref<AnalyzerBeansConfiguration> _undecoratedConfigurationRef;
    private final Ref<UserPreferences> _userPreferencesRef;
    private final Ref<AnalysisJobBuilder> _analysisJobBuilderRef;
    private AnalyzerBeansConfiguration _configuration;
    private WindowContext _windowContext;

    public DCModule(DCModule parent, AnalysisJobBuilder analysisJobBuilder) {
        this._undecoratedConfigurationRef = parent._undecoratedConfigurationRef;
        this._userPreferencesRef = parent._userPreferencesRef;
        this._configuration = parent._configuration;
        this._windowContext = parent._windowContext;
        this._analysisJobBuilderRef = analysisJobBuilder == null ? new MutableRef() : ImmutableRef.of((Object)analysisJobBuilder);
    }

    public DCModule() {
        this(DCModule.defaultDataCleanerHome());
    }

    private static FileObject defaultDataCleanerHome() {
        try {
            return VFSUtils.getFileSystemManager().resolveFile(".");
        }
        catch (FileSystemException e) {
            throw new IllegalStateException(e);
        }
    }

    public DCModule(FileObject dataCleanerHome) {
        this(dataCleanerHome, null);
    }

    public DCModule(FileObject dataCleanerHome, FileObject configurationFile) {
        this._userPreferencesRef = this.createUserPreferencesRef(dataCleanerHome);
        this._undecoratedConfigurationRef = new DataCleanerConfigurationReader(dataCleanerHome, configurationFile, this._userPreferencesRef);
        this._analysisJobBuilderRef = new MutableRef();
        this._configuration = null;
        this._windowContext = null;
    }

    private final Ref<UserPreferences> createUserPreferencesRef(FileObject dataCleanerHome) {
        try {
            if ("true".equalsIgnoreCase(System.getProperty("datacleaner.sandbox"))) {
                return new ImmutableRef((Object)new UserPreferencesImpl(null));
            }
            if (dataCleanerHome == null || !dataCleanerHome.exists()) {
                logger.info("DataCleaner home was not set or does not exist. Non-persistent user preferences will be applied.");
                return new ImmutableRef((Object)new UserPreferencesImpl(null));
            }
            final FileObject userPreferencesFile = dataCleanerHome.resolveFile("userpreferences.dat");
            return new LazyRef<UserPreferences>(){

                protected UserPreferences fetch() {
                    return UserPreferencesImpl.load(userPreferencesFile, true);
                }
            };
        }
        catch (FileSystemException e) {
            throw new IllegalStateException("Not able to resolve files in DataCleaner home: " + dataCleanerHome, e);
        }
    }

    protected void configure() {
        this.bind(AnalysisJobBuilderWindow.class).to(AnalysisJobBuilderWindowImpl.class);
        this.bind(AuthenticationService.class).to(DCAuthenticationService.class);
        this.bind(InjectionManagerFactory.class).to(GuiceInjectionManagerFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Provides
    public final WindowContext getWindowContext(AnalyzerBeansConfiguration configuration, UserPreferences userPreferences, UsageLogger usageLogger) {
        if (this._windowContext != null) return this._windowContext;
        Class<DCModule> clazz = DCModule.class;
        synchronized (DCModule.class) {
            if (this._windowContext != null) return this._windowContext;
            this._windowContext = new DCWindowContext(configuration, userPreferences, usageLogger);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this._windowContext;
        }
    }

    @Provides
    public final TaskRunner getTaskRunner(AnalyzerBeansConfiguration conf) {
        return conf.getTaskRunner();
    }

    @Provides
    public final DescriptorProvider getDescriptorProvider(AnalyzerBeansConfiguration conf) {
        return conf.getDescriptorProvider();
    }

    @Provides
    public final ReferenceDataCatalog getReferenceDataCatalog(AnalyzerBeansConfiguration conf) {
        return conf.getReferenceDataCatalog();
    }

    @Provides
    public final InjectionManager getInjectionManager(InjectionManagerFactory injectionManagerFactory, AnalyzerBeansConfiguration configuration, @Nullable AnalysisJob job) {
        return injectionManagerFactory.getInjectionManager(configuration, job);
    }

    @Provides
    public final LifeCycleHelper getLifeCycleHelper(InjectionManager injectionManager, @Nullable ReferenceDataActivationManager referenceDataActivationManager) {
        return new LifeCycleHelper(injectionManager, referenceDataActivationManager);
    }

    @Provides
    public final DatastoreCatalog getDatastoreCatalog(AnalyzerBeansConfiguration conf) {
        return conf.getDatastoreCatalog();
    }

    @Provides
    public final MutableReferenceDataCatalog getMutableReferenceDataCatalog(ReferenceDataCatalog referenceDataCatalog) {
        return (MutableReferenceDataCatalog)referenceDataCatalog;
    }

    @Provides
    public final MutableDatastoreCatalog getMutableDatastoreCatalog(DatastoreCatalog datastoreCatalog) {
        return (MutableDatastoreCatalog)datastoreCatalog;
    }

    @Provides
    @Undecorated
    public final AnalyzerBeansConfiguration getUndecoratedAnalyzerBeansConfiguration() {
        return (AnalyzerBeansConfiguration)this._undecoratedConfigurationRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Provides
    public final AnalyzerBeansConfiguration getAnalyzerBeansConfiguration(@Undecorated AnalyzerBeansConfiguration c, UserPreferences userPreferences, InjectionManagerFactory injectionManagerFactory) {
        if (this._configuration == null) {
            Class<DCModule> clazz = DCModule.class;
            // MONITORENTER : org.eobjects.datacleaner.guice.DCModule.class
            if (this._configuration == null) {
                MutableDatastoreCatalog datastoreCatalog = new MutableDatastoreCatalog(c.getDatastoreCatalog(), userPreferences);
                MutableReferenceDataCatalog referenceDataCatalog = new MutableReferenceDataCatalog(c.getReferenceDataCatalog(), userPreferences, new LifeCycleHelper(injectionManagerFactory.getInjectionManager(c, null), null));
                DescriptorProvider descriptorProvider = c.getDescriptorProvider();
                List<ExtensionPackage> extensionPackages = userPreferences.getExtensionPackages();
                for (ExtensionPackage extensionPackage : extensionPackages) {
                    extensionPackage.loadDescriptors(descriptorProvider);
                }
                StorageProvider storageProvider = c.getStorageProvider();
                this._configuration = new AnalyzerBeansConfigurationImpl((DatastoreCatalog)datastoreCatalog, (ReferenceDataCatalog)referenceDataCatalog, descriptorProvider, c.getTaskRunner(), storageProvider, injectionManagerFactory);
            }
            // MONITOREXIT : clazz
        }
        if (!(this._configuration instanceof AnalyzerBeansConfigurationImpl)) return this._configuration;
        return ((AnalyzerBeansConfigurationImpl)this._configuration).replace(injectionManagerFactory);
    }

    @Provides
    public AnalysisJob getAnalysisJob(@Nullable AnalysisJobBuilder builder) {
        if (builder == null) {
            return null;
        }
        return builder.toAnalysisJob();
    }

    @Provides
    public final RendererFactory getRendererFactory(AnalyzerBeansConfiguration configuration) {
        return new RendererFactory(configuration);
    }

    @Provides
    public AnalysisJobBuilder getAnalysisJobBuilder(AnalyzerBeansConfiguration configuration) {
        AnalysisJobBuilder ajb = (AnalysisJobBuilder)this._analysisJobBuilderRef.get();
        if (ajb == null && this._analysisJobBuilderRef instanceof MutableRef) {
            ajb = new AnalysisJobBuilder(configuration);
            MutableRef ref = (MutableRef)this._analysisJobBuilderRef;
            ref.set((Object)ajb);
        }
        return ajb;
    }

    @Provides
    @JobFile
    public FileObject getJobFilename() {
        return null;
    }

    @Provides
    public final DCModule getModule() {
        return this;
    }

    @Provides
    public AnalysisResult getAnalysisResult() {
        return null;
    }

    @Provides
    public final UserPreferences getUserPreferences() {
        return (UserPreferences)this._userPreferencesRef.get();
    }

    @Provides
    public HttpClient getHttpClient(HttpXmlUtils httpXmlUtils) {
        return httpXmlUtils.getHttpClient();
    }
}

