/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.guice;

import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.configuration.InjectionManagerImpl;
import org.eobjects.analyzer.configuration.InjectionPoint;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GuiceInjectionManager
extends InjectionManagerImpl {
    private static final Logger logger = LoggerFactory.getLogger(GuiceInjectionManager.class);
    private final InjectorBuilder _injectorBuilder;

    public GuiceInjectionManager(AnalyzerBeansConfiguration configuration, AnalysisJob job, InjectorBuilder injectorBuilder) {
        super(configuration, job);
        this._injectorBuilder = injectorBuilder;
    }

    protected Object getInstanceInternal(InjectionPoint<?> injectionPoint) {
        Object instance = super.getInstanceInternal(injectionPoint);
        if (instance == null) {
            Class baseType = injectionPoint.getBaseType();
            try {
                instance = this._injectorBuilder.getInstance(baseType);
            }
            catch (Exception e) {
                logger.warn("Error occurred while getting guice instance for injection point: " + injectionPoint, (Throwable)e);
            }
        }
        return instance;
    }
}

