/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.guice;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.datacleaner.guice.AdHocModule;
import org.eobjects.datacleaner.guice.DCModule;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;

public final class InjectorBuilder {
    private final List<TypeLiteral<?>> _inheritedTypeLiterals;
    private final AdHocModule _adHocModule;
    private final DCModule _parentModule;
    private final Injector _parentInjector;

    @Inject
    protected InjectorBuilder(DCModule parentModule, Injector injector) {
        this._parentModule = parentModule;
        this._parentInjector = injector;
        this._adHocModule = new AdHocModule();
        this._inheritedTypeLiterals = new ArrayList();
        this.inherit(AnalysisJobBuilderWindow.class);
        this.inherit(Datastore.class);
    }

    public InjectorBuilder with(Class<?> bindingClass, Object providerOrInstance) {
        this._adHocModule.bind(bindingClass, providerOrInstance);
        return this;
    }

    public InjectorBuilder with(TypeLiteral<?> bindingTypeLiteral, Object providerOrInstance) {
        this._adHocModule.bind(bindingTypeLiteral, providerOrInstance);
        return this;
    }

    public InjectorBuilder inherit(Class<?> bindingClass) {
        return this.inherit(Key.get(bindingClass));
    }

    public InjectorBuilder inherit(Key<?> key) {
        return this.inherit(key.getTypeLiteral());
    }

    public InjectorBuilder inherit(TypeLiteral<?> typeLiteral) {
        if (!this._inheritedTypeLiterals.contains(typeLiteral)) {
            this._inheritedTypeLiterals.add(typeLiteral);
        }
        return this;
    }

    public <E> E getInstance(Class<E> type) {
        return (E)this.createInjector().getInstance(type);
    }

    public Injector createInjector() {
        for (TypeLiteral<?> typeLiteral : this._inheritedTypeLiterals) {
            Key key = Key.get(typeLiteral);
            Binding binding = this._parentInjector.getExistingBinding(key);
            if (binding == null || this._adHocModule.hasBindingFor(typeLiteral)) continue;
            this._adHocModule.bind(typeLiteral, (Object)binding.getProvider());
        }
        Module module = Modules.override((Module[])new Module[]{this._parentModule}).with(new Module[]{this._adHocModule});
        return Guice.createInjector((Module[])new Module[]{module});
    }
}

