/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.macos;

import com.google.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.actions.OpenAnalysisJobActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.windows.AboutDialog;
import org.eobjects.datacleaner.windows.OptionsDialog;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacOSManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final WindowContext _windowContext;
    private final Provider<OpenAnalysisJobActionListener> _openAnalysisJobActionListenerProvider;
    private final Provider<OptionsDialog> _optionsDialogProvider;

    @Inject
    protected MacOSManager(WindowContext windowContext, Provider<OpenAnalysisJobActionListener> openAnalysisJobActionListenerProvider, Provider<OptionsDialog> optionsDialogProvider) {
        this._windowContext = windowContext;
        this._openAnalysisJobActionListenerProvider = openAnalysisJobActionListenerProvider;
        this._optionsDialogProvider = optionsDialogProvider;
    }

    public void init() {
        DefaultApplication app = new DefaultApplication();
        if (!app.isMac()) {
            this.logger.debug("Omitting Mac OS initialization, since operating system is not Mac OS");
            return;
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        app.addAboutMenuItem();
        app.setEnabledAboutMenu(true);
        app.addPreferencesMenuItem();
        app.setEnabledPreferencesMenu(true);
        app.addApplicationListener((ApplicationListener)new DCApplicationListener());
    }

    public class DCApplicationListener
    implements ApplicationListener {
        public void handleAbout(ApplicationEvent event) {
            AboutDialog dialog = new AboutDialog(MacOSManager.this._windowContext);
            dialog.setVisible(true);
            event.setHandled(true);
        }

        public void handleOpenFile(ApplicationEvent event) {
            String filename = event.getFilename();
            OpenAnalysisJobActionListener actionListener = (OpenAnalysisJobActionListener)MacOSManager.this._openAnalysisJobActionListenerProvider.get();
            try {
                FileObject file = VFSUtils.getFileSystemManager().resolveFile(filename);
                actionListener.openFile(file);
            }
            catch (FileSystemException e) {
                throw new IllegalArgumentException("Could not resolve filename: " + filename, e);
            }
        }

        public void handlePreferences(ApplicationEvent event) {
            OptionsDialog dialog = (OptionsDialog)MacOSManager.this._optionsDialogProvider.get();
            dialog.setVisible(true);
        }

        public void handleQuit(ApplicationEvent event) {
            MacOSManager.this._windowContext.exit();
        }

        public void handleOpenApplication(ApplicationEvent event) {
        }

        public void handlePrintFile(ApplicationEvent event) {
        }

        public void handleReOpenApplication(ApplicationEvent event) {
        }
    }
}

