/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output;

import org.apache.commons.lang.ArrayUtils;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.datacleaner.output.AbstractMetaModelOutputWriter;
import org.eobjects.datacleaner.output.OutputRow;

final class MetaModelOutputRow
implements OutputRow {
    private final Object[] _values;
    private final AbstractMetaModelOutputWriter _outputWriter;
    private final InputColumn<?>[] _columns;

    public MetaModelOutputRow(AbstractMetaModelOutputWriter outputWriter, InputColumn<?>[] columns) {
        this._outputWriter = outputWriter;
        this._columns = columns;
        this._values = new Object[columns.length];
    }

    @Override
    public <E> OutputRow setValue(InputColumn<? super E> inputColumn, E value) {
        int index = ArrayUtils.indexOf((Object[])this._columns, inputColumn);
        if (index != -1) {
            this._values[index] = value;
        }
        return this;
    }

    @Override
    public OutputRow setValues(InputRow row) {
        for (int i = 0; i < this._columns.length; ++i) {
            Object value;
            this._values[i] = value = row.getValue(this._columns[i]);
        }
        return this;
    }

    @Override
    public void write() {
        this._outputWriter.addToBuffer(this._values);
    }
}

