/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output.beans;

import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.beans.api.Analyzer;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Initialize;
import org.eobjects.analyzer.beans.writers.WriteDataResult;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.output.OutputRow;
import org.eobjects.datacleaner.output.OutputWriter;

public abstract class AbstractOutputWriterAnalyzer
implements Analyzer<WriteDataResult> {
    private final AtomicInteger rowCount = new AtomicInteger(0);
    @Configured
    InputColumn<?>[] columns;
    protected OutputWriter outputWriter;

    @Initialize
    public final void init() {
        this.outputWriter = this.createOutputWriter();
    }

    public final WriteDataResult getResult() {
        this.outputWriter.close();
        return this.getResultInternal(this.rowCount.get());
    }

    protected abstract WriteDataResult getResultInternal(int var1);

    public abstract OutputWriter createOutputWriter();

    public abstract void configureForFilterOutcome(AnalysisJobBuilder var1, FilterBeanDescriptor<?, ?> var2, String var3);

    public abstract void configureForTransformedData(AnalysisJobBuilder var1, TransformerBeanDescriptor<?> var2);

    public final void run(InputRow row, int distinctCount) {
        this.writeRow(row, distinctCount);
        this.rowCount.incrementAndGet();
    }

    protected void writeRow(InputRow row, int distinctCount) {
        OutputRow outputRow = this.outputWriter.createRow();
        InputColumn<?>[] arr$ = this.columns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            InputColumn<?> col;
            InputColumn<?> objectCol = col = arr$[i$];
            outputRow.setValue(objectCol, row.getValue(col));
        }
        outputRow.write();
    }

    public void setColumns(InputColumn<?>[] columns) {
        this.columns = columns;
    }

    public InputColumn<?>[] getColumns() {
        return this.columns;
    }
}

