/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output.beans;

import java.io.File;
import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.FileProperty;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.writers.WriteDataCategory;
import org.eobjects.analyzer.beans.writers.WriteDataResult;
import org.eobjects.analyzer.beans.writers.WriteDataResultImpl;
import org.eobjects.analyzer.connection.CsvDatastore;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.output.OutputWriter;
import org.eobjects.datacleaner.output.beans.AbstractOutputWriterAnalyzer;
import org.eobjects.datacleaner.output.csv.CsvOutputWriterFactory;
import org.eobjects.datacleaner.user.UserPreferences;

@AnalyzerBean(value="Create CSV file")
@Alias(value={"Write to CSV file"})
@Description(value="Write data to a CSV file on your harddrive. CSV file writing is extremely fast and the file format is commonly used in many tools. But CSV files do not preserve data types.")
@Categorized(value={WriteDataCategory.class})
public class CreateCsvFileAnalyzer
extends AbstractOutputWriterAnalyzer {
    @Configured
    char separatorChar = (char)44;
    @Configured
    char quoteChar = (char)34;
    @Configured
    @FileProperty(accessMode=FileProperty.FileAccessMode.SAVE, extension={"csv", "tsv", "txt", "dat"})
    File file;
    @Inject
    @Provided
    UserPreferences userPreferences;

    @Override
    public void configureForFilterOutcome(AnalysisJobBuilder ajb, FilterBeanDescriptor<?, ?> descriptor, String categoryName) {
        String dsName = ajb.getDatastore().getName();
        File saveDatastoreDirectory = this.userPreferences.getSaveDatastoreDirectory();
        String displayName = descriptor.getDisplayName();
        this.file = new File(saveDatastoreDirectory, "output-" + dsName + "-" + displayName + "-" + categoryName + ".csv");
    }

    @Override
    public void configureForTransformedData(AnalysisJobBuilder ajb, TransformerBeanDescriptor<?> descriptor) {
        String dsName = ajb.getDatastore().getName();
        File saveDatastoreDirectory = this.userPreferences.getSaveDatastoreDirectory();
        String displayName = descriptor.getDisplayName();
        this.file = new File(saveDatastoreDirectory, "output-" + dsName + "-" + displayName + ".csv");
    }

    @Override
    public OutputWriter createOutputWriter() {
        String[] headers = new String[this.columns.length];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = this.columns[i].getName();
        }
        return CsvOutputWriterFactory.getWriter(this.file.getPath(), headers, this.separatorChar, this.quoteChar, this.columns);
    }

    @Override
    protected WriteDataResult getResultInternal(int rowCount) {
        CsvDatastore datastore = new CsvDatastore(this.file.getName(), this.file.getAbsolutePath(), Character.valueOf(this.quoteChar), Character.valueOf(this.separatorChar), "UTF-8");
        return new WriteDataResultImpl(rowCount, (Datastore)datastore, null, null);
    }

    public void setFile(File file) {
        this.file = file;
    }
}

