/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output.beans;

import java.io.File;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.FileProperty;
import org.eobjects.analyzer.beans.api.Validate;
import org.eobjects.analyzer.beans.writers.WriteDataCategory;
import org.eobjects.analyzer.beans.writers.WriteDataResult;
import org.eobjects.analyzer.beans.writers.WriteDataResultImpl;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.ExcelDatastore;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.output.OutputWriter;
import org.eobjects.datacleaner.output.beans.AbstractOutputWriterAnalyzer;
import org.eobjects.datacleaner.output.excel.ExcelOutputWriterFactory;

@AnalyzerBean(value="Create Excel spreadsheet")
@Alias(value={"Write to Excel spreadsheet"})
@Description(value="Write data to an Excel spreadsheet, useful for manually editing and inspecting the data in Microsoft Excel.")
@Categorized(value={WriteDataCategory.class})
public class CreateExcelSpreadsheetAnalyzer
extends AbstractOutputWriterAnalyzer {
    @Configured
    @FileProperty(accessMode=FileProperty.FileAccessMode.SAVE, extension={"xls", "xlsx"})
    File file = new File("DataCleaner-staging.xlsx");
    @Configured
    String sheetName;

    @Validate
    public void validate() {
        if (this.sheetName.indexOf(".") != -1) {
            throw new IllegalStateException("Sheet name cannot contain dots (.)");
        }
    }

    @Override
    public void configureForFilterOutcome(AnalysisJobBuilder ajb, FilterBeanDescriptor<?, ?> descriptor, String categoryName) {
        String dsName = ajb.getDatastoreConnection().getDatastore().getName();
        this.sheetName = "output-" + dsName + "-" + descriptor.getDisplayName() + "-" + categoryName;
    }

    @Override
    public void configureForTransformedData(AnalysisJobBuilder ajb, TransformerBeanDescriptor<?> descriptor) {
        String dsName = ajb.getDatastoreConnection().getDatastore().getName();
        this.sheetName = "output-" + dsName + "-" + descriptor.getDisplayName();
    }

    @Override
    public OutputWriter createOutputWriter() {
        String[] headers = new String[this.columns.length];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = this.columns[i].getName();
        }
        return ExcelOutputWriterFactory.getWriter(this.file.getPath(), this.sheetName, this.columns);
    }

    @Override
    protected WriteDataResult getResultInternal(int rowCount) {
        ExcelDatastore datastore = new ExcelDatastore(this.file.getName(), this.file.getAbsolutePath());
        WriteDataResultImpl result = new WriteDataResultImpl(rowCount, (Datastore)datastore, null, this.sheetName);
        return result;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }
}

