/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output.beans;

import javax.inject.Inject;
import org.eobjects.analyzer.beans.api.Alias;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.Categorized;
import org.eobjects.analyzer.beans.api.Configured;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.writers.WriteDataCategory;
import org.eobjects.analyzer.beans.writers.WriteDataResult;
import org.eobjects.analyzer.beans.writers.WriteDataResultImpl;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.output.OutputWriter;
import org.eobjects.datacleaner.output.beans.AbstractOutputWriterAnalyzer;
import org.eobjects.datacleaner.output.datastore.DatastoreCreationDelegate;
import org.eobjects.datacleaner.output.datastore.DatastoreCreationDelegateImpl;
import org.eobjects.datacleaner.output.datastore.DatastoreOutputWriter;
import org.eobjects.datacleaner.output.datastore.DatastoreOutputWriterFactory;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.user.UserPreferences;

@AnalyzerBean(value="Create staging table")
@Alias(value={"Write to Datastore"})
@Description(value="Write data to DataCleaner's embedded staging database (based on H2), which provides a convenient location for staging data or simply storing data temporarily for further analysis.")
@Categorized(value={WriteDataCategory.class})
public class CreateStagingTableAnalyzer
extends AbstractOutputWriterAnalyzer {
    @Configured(order=1)
    String datastoreName = "DataCleaner-staging";
    @Configured(order=2)
    String tableName;
    @Configured(order=3)
    @Description(value="Determines the behaviour in case of there's an existing datastore and table with the given names.")
    WriteMode writeMode = WriteMode.TRUNCATE;
    @Inject
    UserPreferences userPreferences;
    @Inject
    DatastoreCatalog datastoreCatalog;

    @Override
    public void configureForFilterOutcome(AnalysisJobBuilder ajb, FilterBeanDescriptor<?, ?> descriptor, String categoryName) {
        String dsName = ajb.getDatastoreConnection().getDatastore().getName();
        this.tableName = "output-" + dsName + "-" + descriptor.getDisplayName() + "-" + categoryName;
    }

    @Override
    public void configureForTransformedData(AnalysisJobBuilder ajb, TransformerBeanDescriptor<?> descriptor) {
        String dsName = ajb.getDatastoreConnection().getDatastore().getName();
        this.tableName = "output-" + dsName + "-" + descriptor.getDisplayName();
    }

    @Override
    public OutputWriter createOutputWriter() {
        String[] headers = new String[this.columns.length];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = this.columns[i].getName();
        }
        boolean truncate = this.writeMode == WriteMode.TRUNCATE;
        DatastoreCreationDelegateImpl creationDelegate = new DatastoreCreationDelegateImpl((MutableDatastoreCatalog)this.datastoreCatalog);
        DatastoreOutputWriter outputWriter = DatastoreOutputWriterFactory.getWriter(this.userPreferences.getSaveDatastoreDirectory(), (DatastoreCreationDelegate)creationDelegate, this.datastoreName, this.tableName, truncate, this.columns);
        this.tableName = DatastoreOutputWriterFactory.getActualTableName(outputWriter);
        return outputWriter;
    }

    @Override
    protected WriteDataResult getResultInternal(int rowCount) {
        WriteDataResultImpl result = new WriteDataResultImpl(rowCount, this.datastoreName, null, this.tableName);
        return result;
    }

    public String getDatastoreName() {
        return this.datastoreName;
    }

    public void setDatastoreName(String datastoreName) {
        this.datastoreName = datastoreName;
    }

    public static enum WriteMode {
        TRUNCATE,
        NEW_TABLE;

    }
}

