/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output.csv;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.datacleaner.output.OutputWriter;
import org.eobjects.datacleaner.output.csv.CsvOutputWriter;
import org.eobjects.metamodel.UpdateCallback;
import org.eobjects.metamodel.UpdateScript;
import org.eobjects.metamodel.UpdateableDataContext;
import org.eobjects.metamodel.create.TableCreationBuilder;
import org.eobjects.metamodel.csv.CsvConfiguration;
import org.eobjects.metamodel.csv.CsvDataContext;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

public final class CsvOutputWriterFactory {
    private static final Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
    private static final Map<String, UpdateableDataContext> dataContexts = new HashMap<String, UpdateableDataContext>();

    public static OutputWriter getWriter(String filename, List<InputColumn<?>> columns) {
        return CsvOutputWriterFactory.getWriter(filename, columns.toArray(new InputColumn[columns.size()]));
    }

    public static OutputWriter getWriter(String filename, InputColumn<?> ... columns) {
        return CsvOutputWriterFactory.getWriter(filename, ',', '\"', columns);
    }

    public static OutputWriter getWriter(String filename, char separatorChar, char quoteChar, InputColumn<?> ... columns) {
        String[] headers = new String[columns.length];
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = columns[i].getName();
        }
        return CsvOutputWriterFactory.getWriter(filename, headers, separatorChar, quoteChar, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputWriter getWriter(String filename, final String[] headers, char separatorChar, char quoteChar, InputColumn<?> ... columns) {
        CsvOutputWriter outputWriter;
        Map<String, UpdateableDataContext> map = dataContexts;
        synchronized (map) {
            UpdateableDataContext dataContext = dataContexts.get(filename);
            if (dataContext == null) {
                File file = new File(filename);
                File parentFile = file.getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                dataContext = new CsvDataContext(file, CsvOutputWriterFactory.getConfiguration(separatorChar, quoteChar));
                final Schema schema = dataContext.getDefaultSchema();
                dataContext.executeUpdate(new UpdateScript(){

                    public void run(UpdateCallback callback) {
                        TableCreationBuilder tableBuilder = callback.createTable(schema, "table");
                        for (String header : headers) {
                            tableBuilder.withColumn(header);
                        }
                        tableBuilder.execute();
                    }
                });
                Table table = dataContext.getDefaultSchema().getTables()[0];
                dataContexts.put(filename, dataContext);
                counters.put(filename, new AtomicInteger(1));
                outputWriter = new CsvOutputWriter(dataContext, filename, table, columns);
            } else {
                Table table = dataContext.getDefaultSchema().getTables()[0];
                outputWriter = new CsvOutputWriter(dataContext, filename, table, columns);
                counters.get(filename).incrementAndGet();
            }
        }
        return outputWriter;
    }

    private static CsvConfiguration getConfiguration(char separatorChar, char quoteChar) {
        return new CsvConfiguration(1, "UTF-8", separatorChar, quoteChar, '\\');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void release(String filename) {
        int count = counters.get(filename).decrementAndGet();
        if (count == 0) {
            Map<String, UpdateableDataContext> map = dataContexts;
            synchronized (map) {
                dataContexts.remove(filename);
            }
        }
    }
}

