/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output.datastore;

import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.datacleaner.output.datastore.DatastoreCreationDelegate;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreCreationDelegateImpl
implements DatastoreCreationDelegate {
    private static final Logger logger = LoggerFactory.getLogger(DatastoreCreationDelegateImpl.class);
    private final MutableDatastoreCatalog _datastoreCatalog;

    public DatastoreCreationDelegateImpl(MutableDatastoreCatalog datastoreCatalog) {
        this._datastoreCatalog = datastoreCatalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDatastore(Datastore datastore) {
        String name = datastore.getName();
        MutableDatastoreCatalog mutableDatastoreCatalog = this._datastoreCatalog;
        synchronized (mutableDatastoreCatalog) {
            if (this._datastoreCatalog.containsDatastore(name)) {
                logger.warn("Datastore '{}' already exists. No new datastore will be created!", (Object)name);
            } else {
                this._datastoreCatalog.addDatastore(datastore);
            }
        }
    }
}

