/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output.datastore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.datacleaner.output.OutputRow;
import org.eobjects.datacleaner.output.datastore.DatastoreOutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DatastoreOutputRow
implements OutputRow {
    private static final Logger logger = LoggerFactory.getLogger(DatastoreOutputRow.class);
    private final PreparedStatement _insertStatement;
    private final InputColumn<?>[] _columns;
    private final Map<Integer, Object> _parameters;

    public DatastoreOutputRow(PreparedStatement insertStatement, InputColumn<?>[] columns) {
        this._insertStatement = insertStatement;
        this._columns = columns;
        this._parameters = new HashMap<Integer, Object>();
    }

    @Override
    public <E> OutputRow setValue(InputColumn<? super E> inputColumn, E value) {
        int index = -1;
        for (int i = 0; i < this._columns.length; ++i) {
            if (!inputColumn.equals(this._columns[i])) continue;
            index = i;
        }
        if (index == -1) {
            throw new IllegalArgumentException("Column '" + inputColumn + "' is not being written");
        }
        if (value != null && !DatastoreOutputWriter.isDirectlyInsertableType(inputColumn)) {
            this._parameters.put(index + 1, value.toString());
        } else {
            this._parameters.put(index + 1, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() {
        PreparedStatement preparedStatement = this._insertStatement;
        synchronized (preparedStatement) {
            Set<Map.Entry<Integer, Object>> entries = this._parameters.entrySet();
            try {
                for (Map.Entry<Integer, Object> entry : entries) {
                    this._insertStatement.setObject(entry.getKey(), entry.getValue());
                }
                logger.debug("Writing row based on statement: {}", (Object)this._insertStatement);
                this._insertStatement.executeUpdate();
            }
            catch (SQLException e) {
                logger.error("Exception occurred while executing statement with parameters: {}", this._parameters);
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public OutputRow setValues(InputRow row) {
        for (InputColumn<?> column : this._columns) {
            Object value = row.getValue(column);
            InputColumn<?> objectColumn = column;
            this.setValue(objectColumn, value);
        }
        return this;
    }
}

