/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output.datastore;

import java.io.File;
import org.eobjects.analyzer.util.CharIterator;
import org.eobjects.analyzer.util.StringUtils;

final class DatastoreOutputUtils {
    private DatastoreOutputUtils() {
    }

    public static String safeName(String str) {
        if (StringUtils.isNullOrEmpty((String)str)) {
            throw new IllegalArgumentException("Cannot create safe name from empty/null string: " + str);
        }
        CharIterator ci = new CharIterator((CharSequence)str);
        while (ci.hasNext()) {
            ci.next();
            if (ci.isLetter() || ci.isDigit()) continue;
            ci.set(Character.valueOf('_'));
        }
        str = ci.toString();
        if (!Character.isLetter(str.charAt(0))) {
            str = "db" + str;
        }
        return str;
    }

    public static String getJdbcUrl(File directory, String dbName) {
        String urlSuffix = directory.getPath() + File.separatorChar + DatastoreOutputUtils.safeName(dbName);
        return "jdbc:h2:" + urlSuffix;
    }
}

