/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output.datastore;

import java.io.File;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.JdbcDatastore;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.storage.SqlDatabaseUtils;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.datacleaner.output.OutputRow;
import org.eobjects.datacleaner.output.OutputWriter;
import org.eobjects.datacleaner.output.datastore.DatastoreCreationDelegate;
import org.eobjects.datacleaner.output.datastore.DatastoreOutputRow;
import org.eobjects.datacleaner.output.datastore.DatastoreOutputUtils;
import org.eobjects.datacleaner.output.datastore.DatastoreOutputWriterFactory;
import org.eobjects.metamodel.DataContextFactory;
import org.eobjects.metamodel.UpdateableDataContext;

final class DatastoreOutputWriter
implements OutputWriter {
    private static final String DRIVER_CLASS_NAME = "org.h2.Driver";
    private final String _datastoreName;
    private final String _jdbcUrl;
    private final Connection _connection;
    private final String _tableName;
    private final InputColumn<?>[] _columns;
    private final PreparedStatement _insertStatement;
    private final DatastoreCreationDelegate _datastoreCreationDelegate;

    public DatastoreOutputWriter(String datastoreName, String tableName, File directory, InputColumn<?>[] columns, DatastoreCreationDelegate datastoreCreationDelegate) {
        this(datastoreName, tableName, directory, columns, datastoreCreationDelegate, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreOutputWriter(String datastoreName, String tableName, File directory, InputColumn<?>[] columns, DatastoreCreationDelegate datastoreCreationDelegate, boolean truncateExisting) {
        this._datastoreName = datastoreName;
        this._jdbcUrl = DatastoreOutputUtils.getJdbcUrl(directory, this._datastoreName);
        this._columns = columns;
        this._datastoreCreationDelegate = datastoreCreationDelegate;
        try {
            Class.forName(DRIVER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        try {
            this._connection = DriverManager.getConnection(this._jdbcUrl, "SA", "");
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        tableName = DatastoreOutputUtils.safeName(tableName);
        Class<DatastoreOutputWriter> e = DatastoreOutputWriter.class;
        synchronized (DatastoreOutputWriter.class) {
            UpdateableDataContext dc = DataContextFactory.createJdbcDataContext((Connection)this._connection);
            dc.refreshSchemas();
            String[] tableNames = dc.getDefaultSchema().getTableNames();
            if (truncateExisting) {
                this._tableName = tableName;
                for (String existingTableName : tableNames) {
                    if (!this._tableName.equalsIgnoreCase(existingTableName)) continue;
                    SqlDatabaseUtils.performUpdate((Connection)this._connection, (String)("DROP TABLE " + existingTableName));
                }
            } else {
                int tableNumber = 0;
                boolean accepted = false;
                String proposalName = null;
                block10: while (!accepted) {
                    proposalName = tableName + '_' + ++tableNumber;
                    accepted = true;
                    for (String existingTableName : tableNames) {
                        if (!existingTableName.equalsIgnoreCase(proposalName)) continue;
                        accepted = false;
                        continue block10;
                    }
                }
                this._tableName = proposalName;
            }
            StringBuilder createStatementBuilder = new StringBuilder();
            createStatementBuilder.append("CREATE TABLE ");
            createStatementBuilder.append(this._tableName);
            createStatementBuilder.append(" (");
            for (int i = 0; i < columns.length; ++i) {
                if (i != 0) {
                    createStatementBuilder.append(',');
                }
                InputColumn<?> column = columns[i];
                createStatementBuilder.append(DatastoreOutputUtils.safeName(column.getName()));
                createStatementBuilder.append(' ');
                if (!DatastoreOutputWriter.isDirectlyInsertableType(column)) {
                    createStatementBuilder.append(SqlDatabaseUtils.getSqlType(String.class));
                    continue;
                }
                createStatementBuilder.append(SqlDatabaseUtils.getSqlType((Class)column.getDataType()));
            }
            createStatementBuilder.append(')');
            SqlDatabaseUtils.performUpdate((Connection)this._connection, (String)createStatementBuilder.toString());
            // ** MonitorExit[e] (shouldn't be in output)
            StringBuilder insertStatementBuilder = new StringBuilder();
            insertStatementBuilder.append("INSERT INTO ");
            insertStatementBuilder.append(this._tableName);
            insertStatementBuilder.append(" VALUES (");
            for (int i = 0; i < this._columns.length; ++i) {
                if (i != 0) {
                    insertStatementBuilder.append(',');
                }
                insertStatementBuilder.append('?');
            }
            insertStatementBuilder.append(')');
            try {
                this._insertStatement = this._connection.prepareStatement(insertStatementBuilder.toString());
            }
            catch (SQLException e2) {
                throw new IllegalStateException(e2);
            }
            return;
        }
    }

    @Override
    public OutputRow createRow() {
        return new DatastoreOutputRow(this._insertStatement, this._columns);
    }

    public String getTableName() {
        return this._tableName;
    }

    @Override
    public void close() {
        SqlDatabaseUtils.safeClose(null, (Statement)this._insertStatement);
        DatastoreOutputWriterFactory.release(this);
        JdbcDatastore datastore = new JdbcDatastore(this._datastoreName, this._jdbcUrl, DRIVER_CLASS_NAME, "SA", "", true);
        this._datastoreCreationDelegate.createDatastore((Datastore)datastore);
    }

    public String getJdbcUrl() {
        return this._jdbcUrl;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public static boolean isDirectlyInsertableType(InputColumn<?> column) {
        Class dataType = column.getDataType();
        return ReflectionUtils.isNumber((Type)dataType) || ReflectionUtils.isDate((Type)dataType) || ReflectionUtils.isBoolean((Type)dataType);
    }
}

