/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.output.datastore;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.storage.SqlDatabaseUtils;
import org.eobjects.datacleaner.output.OutputWriter;
import org.eobjects.datacleaner.output.datastore.DatastoreCreationDelegate;
import org.eobjects.datacleaner.output.datastore.DatastoreOutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatastoreOutputWriterFactory {
    private static final Logger logger = LoggerFactory.getLogger(DatastoreOutputWriterFactory.class);
    private static final Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();

    public static OutputWriter getWriter(File directory, DatastoreCreationDelegate creationDelegate, String datastoreName, String tableName, InputColumn<?> ... columns) {
        return DatastoreOutputWriterFactory.getWriter(directory, creationDelegate, datastoreName, tableName, true, columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatastoreOutputWriter getWriter(File directory, DatastoreCreationDelegate creationDelegate, String datastoreName, String tableName, boolean truncate, InputColumn<?> ... columns) {
        if (!directory.exists() && !directory.mkdirs()) {
            logger.error("Failed to create directory for datastores: {}", (Object)directory);
        }
        Map<String, AtomicInteger> map = counters;
        synchronized (map) {
            DatastoreOutputWriter outputWriter = new DatastoreOutputWriter(datastoreName, tableName, directory, columns, creationDelegate, truncate);
            AtomicInteger counter = counters.get(outputWriter.getJdbcUrl());
            if (counter == null) {
                counter = new AtomicInteger();
                counters.put(outputWriter.getJdbcUrl(), counter);
            }
            counter.incrementAndGet();
            return outputWriter;
        }
    }

    public static String getActualTableName(OutputWriter outputWriter) {
        assert (outputWriter instanceof DatastoreOutputWriter);
        DatastoreOutputWriter dow = (DatastoreOutputWriter)outputWriter;
        return dow.getTableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void release(DatastoreOutputWriter writer) {
        Map<String, AtomicInteger> map = counters;
        synchronized (map) {
            int count = counters.get(writer.getJdbcUrl()).decrementAndGet();
            if (count == 0) {
                counters.remove(writer.getJdbcUrl());
                Connection connection = writer.getConnection();
                Statement st = null;
                try {
                    st = connection.createStatement();
                    st.execute("SHUTDOWN");
                }
                catch (SQLException e) {
                    logger.error("Could not invoke SHUTDOWN", (Throwable)e);
                }
                finally {
                    SqlDatabaseUtils.safeClose(null, (Statement)st);
                }
                try {
                    logger.info("Closing connection: {}", (Object)connection);
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error("Could not close connection", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

