/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AbstractBeanWithInputColumnsBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.UnconfiguredConfiguredPropertyException;
import org.eobjects.datacleaner.panels.ComponentJobBuilderPresenter;
import org.eobjects.datacleaner.panels.ConfiguredPropertyTaskPane;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.ChangeRequirementButton;
import org.eobjects.datacleaner.widgets.DCTaskPaneContainer;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetPanel;
import org.eobjects.datacleaner.widgets.visualization.VisualizeJobGraph;
import org.jdesktop.swingx.JXTaskPane;

public abstract class AbstractJobBuilderPanel
extends DCPanel
implements ComponentJobBuilderPresenter {
    private static final long serialVersionUID = 1L;
    private final ImageManager imageManager = ImageManager.getInstance();
    private final DCTaskPaneContainer _taskPaneContainer = WidgetFactory.createTaskPaneContainer();
    private final PropertyWidgetFactory _propertyWidgetFactory;
    private final AbstractBeanJobBuilder<?, ?, ?> _beanJobBuilder;
    private final BeanDescriptor<?> _descriptor;
    private final ChangeRequirementButton _requirementButton;
    private final DCPanel _visualizationPanel;

    protected AbstractJobBuilderPanel(String watermarkImagePath, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, PropertyWidgetFactory propertyWidgetFactory) {
        this(ImageManager.getInstance().getImage(watermarkImagePath, new ClassLoader[0]), 95, 95, beanJobBuilder, propertyWidgetFactory);
    }

    protected AbstractJobBuilderPanel(Image watermarkImage, int watermarkHorizontalPosition, int watermarkVerticalPosition, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, PropertyWidgetFactory propertyWidgetFactory) {
        super(watermarkImage, watermarkHorizontalPosition, watermarkVerticalPosition, WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        this._beanJobBuilder = beanJobBuilder;
        this._descriptor = beanJobBuilder.getDescriptor();
        this._propertyWidgetFactory = propertyWidgetFactory;
        this._visualizationPanel = new DCPanel();
        this._visualizationPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)WidgetUtils.scrolleable((JComponent)((Object)this._taskPaneContainer)), "Center");
        this._requirementButton = beanJobBuilder instanceof AbstractBeanWithInputColumnsBuilder ? new ChangeRequirementButton((AbstractBeanWithInputColumnsBuilder)beanJobBuilder) : null;
        JComponent buttonPanel = this.createTopButtonPanel();
        this.add((Component)buttonPanel, "North");
    }

    protected JComponent createTopButtonPanel() {
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(2, 4, 0));
        if (this._requirementButton != null) {
            buttonPanel.add(this._requirementButton);
        }
        return buttonPanel;
    }

    public ChangeRequirementButton getRequirementButton() {
        return this._requirementButton;
    }

    protected DCTaskPaneContainer getTaskPaneContainer() {
        return this._taskPaneContainer;
    }

    @Override
    public final JComponent createJComponent() {
        this.init();
        JComponent decorate = this.decorate(this);
        this.buildVisualizationTaskPane();
        return decorate;
    }

    public AbstractBeanJobBuilder<?, ?, ?> getJobBuilder() {
        return this._beanJobBuilder;
    }

    protected JComponent decorate(DCPanel panel) {
        return panel;
    }

    private final void init() {
        List<ConfiguredPropertyTaskPane> propertyTaskPanes = this.createPropertyTaskPanes();
        for (ConfiguredPropertyTaskPane propertyTaskPane : propertyTaskPanes) {
            this.buildTaskPane(propertyTaskPane.getProperties(), this.imageManager.getImageIcon(propertyTaskPane.getIconImagePath(), IconUtils.ICON_SIZE_SMALL, this.getClass().getClassLoader()), propertyTaskPane.getTitle(), this._beanJobBuilder, propertyTaskPane.isExpanded());
        }
    }

    private void buildVisualizationTaskPane() {
        if (!this.showContextVisualization()) {
            return;
        }
        ImageIcon icon = this.imageManager.getImageIcon("images/actions/visualize.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
        this.addTaskPane(icon, "Context visualization", this._visualizationPanel);
    }

    protected List<ConfiguredPropertyTaskPane> createPropertyTaskPanes() {
        TreeSet configuredProperties = new TreeSet(this._descriptor.getConfiguredProperties());
        ArrayList<ConfiguredPropertyDescriptor> inputProperties = new ArrayList<ConfiguredPropertyDescriptor>();
        ArrayList<ConfiguredPropertyDescriptor> requiredProperties = new ArrayList<ConfiguredPropertyDescriptor>();
        ArrayList<ConfiguredPropertyDescriptor> optionalProperties = new ArrayList<ConfiguredPropertyDescriptor>();
        for (ConfiguredPropertyDescriptor propertyDescriptor : configuredProperties) {
            boolean required = propertyDescriptor.isRequired();
            if (required && propertyDescriptor.isInputColumn()) {
                inputProperties.add(propertyDescriptor);
                continue;
            }
            if (required) {
                requiredProperties.add(propertyDescriptor);
                continue;
            }
            optionalProperties.add(propertyDescriptor);
        }
        ArrayList<ConfiguredPropertyTaskPane> result = new ArrayList<ConfiguredPropertyTaskPane>();
        result.add(new ConfiguredPropertyTaskPane("Input columns", "images/model/column.png", inputProperties));
        result.add(new ConfiguredPropertyTaskPane("Required properties", "images/menu/options.png", requiredProperties));
        result.add(new ConfiguredPropertyTaskPane("Optional properties (" + optionalProperties.size() + ")", "images/actions/edit.png", optionalProperties, false));
        return result;
    }

    protected void buildTaskPane(List<ConfiguredPropertyDescriptor> properties, Icon icon, String title, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        this.buildTaskPane(properties, icon, title, beanJobBuilder, true);
    }

    protected void buildTaskPane(List<ConfiguredPropertyDescriptor> properties, Icon icon, String title, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, boolean expanded) {
        if (!properties.isEmpty()) {
            PropertyWidgetPanel panel = new PropertyWidgetPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                protected PropertyWidget<?> getPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor) {
                    PropertyWidget<?> propertyWidget = AbstractJobBuilderPanel.this.createPropertyWidget(AbstractJobBuilderPanel.this._beanJobBuilder, propertyDescriptor);
                    AbstractJobBuilderPanel.this.getPropertyWidgetFactory().registerWidget(propertyDescriptor, propertyWidget);
                    return propertyWidget;
                }
            };
            panel.addProperties(properties);
            if (!panel.isEmpty()) {
                this.addTaskPane(icon, title, panel, expanded);
            }
        }
    }

    protected PropertyWidget<?> createPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        return this.getPropertyWidgetFactory().create(propertyDescriptor);
    }

    protected void addTaskPane(Icon icon, String title, JComponent content) {
        this.addTaskPane(icon, title, content, true);
    }

    protected void addTaskPane(Icon icon, String title, JComponent content, boolean expanded) {
        JXTaskPane taskPane = WidgetFactory.createTaskPane(title, icon);
        taskPane.add((Component)content);
        if (!expanded) {
            taskPane.setCollapsed(true);
        }
        this._taskPaneContainer.add(taskPane);
    }

    @Override
    public final void applyPropertyValues() {
        this.applyPropertyValues(true);
    }

    public final void applyPropertyValues(boolean errorAware) {
        for (PropertyWidget<?> propertyWidget : this.getPropertyWidgetFactory().getWidgets()) {
            ConfiguredPropertyDescriptor propertyDescriptor = propertyWidget.getPropertyDescriptor();
            if (propertyWidget.isSet()) {
                Object value = propertyWidget.getValue();
                this.setConfiguredProperty(propertyDescriptor, value);
                continue;
            }
            if (!errorAware || !propertyDescriptor.isRequired()) continue;
            throw new UnconfiguredConfiguredPropertyException(this._beanJobBuilder, propertyDescriptor);
        }
    }

    public final PropertyWidgetFactory getPropertyWidgetFactory() {
        return this._propertyWidgetFactory;
    }

    public AnalysisJobBuilder getAnalysisJobBuilder() {
        return this._beanJobBuilder.getAnalysisJobBuilder();
    }

    protected void setConfiguredProperty(ConfiguredPropertyDescriptor propertyDescriptor, Object value) {
        this._beanJobBuilder.setConfiguredProperty(propertyDescriptor, value);
    }

    @Override
    public void onConfigurationChanged() {
        this.getPropertyWidgetFactory().onConfigurationChanged();
        if (this.showContextVisualization()) {
            AbstractBeanJobBuilder<?, ?, ?> jobBuilder = this.getJobBuilder();
            this._visualizationPanel.removeAll();
            if (jobBuilder.isConfigured()) {
                JComponent visualization = VisualizeJobGraph.create(jobBuilder);
                this._visualizationPanel.add((Component)visualization, "Center");
            }
            this._visualizationPanel.updateUI();
        }
    }

    public void onRequirementChanged() {
        this._requirementButton.updateText();
    }

    protected boolean showContextVisualization() {
        return true;
    }
}

