/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import javax.swing.JComponent;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AbstractBeanWithInputColumnsBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.datacleaner.panels.AbstractJobBuilderPanel;
import org.eobjects.datacleaner.panels.AnalyzerJobBuilderPresenter;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.widgets.ChangeRequirementButton;
import org.eobjects.datacleaner.widgets.properties.MultipleInputColumnsPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;

public class AnalyzerJobBuilderPanel
extends AbstractJobBuilderPanel
implements AnalyzerJobBuilderPresenter {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private static final Image WATERMARK_IMAGE = imageManager.getImage("images/window/analyzer-tab-background.png", new ClassLoader[0]);
    private final AnalyzerJobBuilder<?> _analyzerJobBuilder;
    private final ChangeRequirementButton _requirementButton;
    private final DCPanel _buttonPanel;

    public AnalyzerJobBuilderPanel(AnalyzerJobBuilder<?> analyzerJobBuilder, PropertyWidgetFactory propertyWidgetFactory) {
        this(analyzerJobBuilder, true, propertyWidgetFactory);
    }

    public AnalyzerJobBuilderPanel(AnalyzerJobBuilder<?> analyzerJobBuilder, boolean displayRequirementButton, PropertyWidgetFactory propertyWidgetFactory) {
        this(WATERMARK_IMAGE, 95, 95, analyzerJobBuilder, displayRequirementButton, propertyWidgetFactory);
    }

    public AnalyzerJobBuilderPanel(Image watermarkImage, int watermarkHorizontalPosition, int watermarkVerticalPosition, AnalyzerJobBuilder<?> analyzerJobBuilder, boolean displayRequirementButton, PropertyWidgetFactory propertyWidgetFactory) {
        super(watermarkImage, watermarkHorizontalPosition, watermarkVerticalPosition, (AbstractBeanJobBuilder<?, ?, ?>)analyzerJobBuilder, propertyWidgetFactory);
        this._analyzerJobBuilder = analyzerJobBuilder;
        this._requirementButton = new ChangeRequirementButton((AbstractBeanWithInputColumnsBuilder<?, ?, ?>)analyzerJobBuilder);
        this._buttonPanel = new DCPanel();
        this._buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        if (displayRequirementButton) {
            this.addToButtonPanel(this._requirementButton);
        }
        this.add((Component)this._buttonPanel, "North");
    }

    public void addToButtonPanel(JComponent component) {
        this._buttonPanel.add(component);
    }

    @Override
    protected PropertyWidget<?> createPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        if (this._analyzerJobBuilder.isMultipleJobsSupported() && this._analyzerJobBuilder.isMultipleJobsDeterminedBy(propertyDescriptor)) {
            MultipleInputColumnsPropertyWidget propertyWidget = new MultipleInputColumnsPropertyWidget(beanJobBuilder, propertyDescriptor);
            return propertyWidget;
        }
        return super.createPropertyWidget(beanJobBuilder, propertyDescriptor);
    }

    @Override
    public AnalyzerJobBuilder<?> getJobBuilder() {
        return this._analyzerJobBuilder;
    }
}

