/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableModel;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.analyzer.util.InputColumnComparator;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.datacleaner.actions.PreviewSourceDataActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.jdesktop.swingx.HorizontalLayout;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.table.TableColumnExt;

public final class ColumnListTable
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] headers = new String[]{"Name", "Type", ""};
    private final ImageManager imageManager = ImageManager.getInstance();
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final Table _table;
    private final DCTable _columnTable;
    private final List<InputColumn<?>> _columns = new ArrayList();
    private final WindowContext _windowContext;

    public ColumnListTable(Collection<? extends InputColumn<?>> columns, AnalysisJobBuilder analysisJobBuilder, boolean addShadowBorder, WindowContext windowContext) {
        this(null, columns, analysisJobBuilder, addShadowBorder, windowContext);
    }

    public ColumnListTable(Table table, AnalysisJobBuilder analysisJobBuilder, boolean addShadowBorder, WindowContext windowContext) {
        this(table, null, analysisJobBuilder, addShadowBorder, windowContext);
    }

    private ColumnListTable(Table table, Collection<? extends InputColumn<?>> columns, AnalysisJobBuilder analysisJobBuilder, boolean addShadowBorder, WindowContext windowContext) {
        this._table = table;
        this._analysisJobBuilder = analysisJobBuilder;
        this._windowContext = windowContext;
        this.setLayout(new BorderLayout());
        if (table != null) {
            DCPanel headerPanel = new DCPanel();
            headerPanel.setLayout(new FlowLayout(0, 0, 0));
            JLabel tableNameLabel = new JLabel(table.getQualifiedLabel(), this.imageManager.getImageIcon("images/model/column.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]), 2);
            tableNameLabel.setOpaque(false);
            tableNameLabel.setFont(WidgetUtils.FONT_HEADER1);
            JButton previewButton = WidgetFactory.createSmallButton("images/actions/preview_data.png");
            previewButton.setToolTipText("Preview table rows");
            previewButton.addActionListener(new PreviewSourceDataActionListener(this._windowContext, this._analysisJobBuilder.getDatastore(), this._columns));
            JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
            removeButton.setToolTipText("Remove table from source");
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Column[] cols;
                    for (Column col : cols = ColumnListTable.this._table.getColumns()) {
                        ColumnListTable.this._analysisJobBuilder.removeSourceColumn(col);
                    }
                }
            });
            headerPanel.add(tableNameLabel);
            headerPanel.add(Box.createHorizontalStrut(4));
            headerPanel.add(previewButton);
            headerPanel.add(Box.createHorizontalStrut(4));
            headerPanel.add(removeButton);
            this.add((Component)headerPanel, "North");
        }
        this._columnTable = new DCTable(headers);
        this._columnTable.setSortable(false);
        this._columnTable.setColumnControlVisible(false);
        this._columnTable.setRowHeight(IconUtils.ICON_SIZE_SMALL + 4);
        DCPanel tablePanel = this._columnTable.toPanel();
        if (addShadowBorder) {
            tablePanel.setBorder(new CompoundBorder(WidgetUtils.BORDER_SHADOW, WidgetUtils.BORDER_THIN));
        }
        this.add((Component)tablePanel, "Center");
        if (columns != null) {
            for (InputColumn<?> column : columns) {
                this._columns.add(column);
            }
        }
        this.updateComponents();
    }

    private void updateComponents() {
        DefaultTableModel model = new DefaultTableModel(headers, this._columns.size());
        int i = 0;
        for (final InputColumn<?> column : this._columns) {
            Icon icon = IconUtils.getColumnIcon(column, IconUtils.ICON_SIZE_SMALL);
            if (column instanceof MutableInputColumn) {
                final JXTextField textField = WidgetFactory.createTextField("Column name");
                textField.setText(column.getName());
                final MutableInputColumn mutableInputColumn = (MutableInputColumn)column;
                textField.addFocusListener((FocusListener)new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (!mutableInputColumn.getName().equals(textField.getText())) {
                            mutableInputColumn.setName(textField.getText());
                            TransformerJobBuilder tjb = ColumnListTable.this._analysisJobBuilder.getOriginatingTransformer((InputColumn)mutableInputColumn);
                            if (tjb != null) {
                                tjb.onOutputChanged();
                            }
                        }
                    }
                });
                JButton resetButton = this.getResetButton(textField, mutableInputColumn);
                DCPanel panel = new DCPanel();
                panel.setLayout((LayoutManager)new HorizontalLayout(4));
                panel.add(new JLabel(icon));
                panel.add((Component)textField);
                panel.add(resetButton);
                model.setValueAt(panel, i, 0);
            } else {
                model.setValueAt(new JLabel(column.getName(), icon, 2), i, 0);
            }
            Class dataType = column.getDataType();
            String dataTypeString = LabelUtils.getDataTypeLabel((Class)dataType);
            model.setValueAt(dataTypeString, i, 1);
            JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
            removeButton.setToolTipText("Remove column from source");
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColumnListTable.this._analysisJobBuilder.removeSourceColumn(column.getPhysicalColumn());
                }
            });
            DCPanel buttonPanel = new DCPanel();
            buttonPanel.setLayout(new FlowLayout(1, 4, 0));
            if (column.isPhysicalColumn()) {
                buttonPanel.add(removeButton);
            }
            model.setValueAt(buttonPanel, i, 2);
            ++i;
        }
        this._columnTable.setModel(model);
        TableColumnExt columnExt = this._columnTable.getColumnExt(2);
        columnExt.setMinWidth(26);
        columnExt.setMaxWidth(80);
        columnExt.setPreferredWidth(30);
    }

    private JButton getResetButton(final JXTextField textField, final MutableInputColumn<?> mutableInputColumn) {
        JButton button = WidgetFactory.createSmallButton("images/actions/reset.png");
        button.setToolTipText("Reset output column name");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                textField.setText(mutableInputColumn.getInitialName());
            }
        });
        return button;
    }

    public Table getTable() {
        return this._table;
    }

    public void addColumn(InputColumn<?> column) {
        if (!this._columns.contains(column)) {
            this._columns.add(column);
            Collections.sort(this._columns, new InputColumnComparator());
        }
        this.updateComponents();
    }

    public void removeColumn(InputColumn<?> column) {
        this._columns.remove(column);
        this.updateComponents();
    }

    public void setColumns(List<? extends InputColumn<?>> columns) {
        this._columns.clear();
        for (InputColumn<?> column : columns) {
            this._columns.add(column);
        }
        this.updateComponents();
    }

    public int getColumnCount() {
        return this._columns.size();
    }
}

