/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;

public class DCBannerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Image DEFAULT_LEFT_IMAGE = ImageManager.getInstance().getImage("images/window/banner-logo.png", new ClassLoader[0]);
    private static final Image DEFAULT_BG_IMAGE = ImageManager.getInstance().getImage("images/window/banner-bg.png", new ClassLoader[0]);
    private static final Image DEFAULT_RIGHT_IMAGE = ImageManager.getInstance().getImage("images/window/banner-right.png", new ClassLoader[0]);
    private static final int DEFAULT_HEIGHT = 80;
    private final int _titleIndent;
    private final Image _leftImage;
    private final Image _rightImage;
    private final Image _bgImage;
    private final String _title1;
    private String _title2;

    public DCBannerPanel() {
        this((String)null);
    }

    public DCBannerPanel(String title) {
        this(DEFAULT_LEFT_IMAGE, title);
    }

    public DCBannerPanel(Image bannerImage) {
        this(bannerImage, null);
    }

    public DCBannerPanel(Image bannerImage, String title) {
        this(bannerImage, DEFAULT_BG_IMAGE, DEFAULT_RIGHT_IMAGE, title);
    }

    public DCBannerPanel(Image leftImage, Image bgImage, Image rightImage, String title) {
        this._leftImage = leftImage;
        this._bgImage = bgImage;
        this._rightImage = rightImage;
        if (title == null) {
            this._title1 = null;
            this._title2 = null;
        } else {
            int linebreak = title.indexOf(10);
            if (linebreak == -1) {
                this._title1 = title;
                this._title2 = null;
            } else {
                this._title1 = title.substring(0, linebreak);
                this._title2 = title.substring(linebreak + 1);
            }
        }
        this._titleIndent = leftImage == null ? 0 : leftImage.getWidth(this);
        this.setOpaque(false);
    }

    public String getTitle1() {
        return this._title1;
    }

    public String getTitle2() {
        return this._title2;
    }

    public void setTitle2(String title2) {
        this._title2 = title2;
    }

    @Override
    public int getHeight() {
        if (this._bgImage != null) {
            return this._bgImage.getHeight(this);
        }
        if (this._leftImage != null) {
            return this._leftImage.getHeight(this);
        }
        if (this._rightImage != null) {
            return this._rightImage.getHeight(this);
        }
        return 80;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(400, this.getHeight());
        return dimension;
    }

    @Override
    public void paint(Graphics g) {
        int x = this.getX();
        boolean y = false;
        int w = this.getWidth();
        for (int offset = 0; offset < w; offset += this._bgImage.getWidth(this)) {
            g.drawImage(this._bgImage, x + offset, 0, this);
        }
        if (this._leftImage != null) {
            g.drawImage(this._leftImage, x, 0, this);
        }
        if (this._rightImage != null) {
            int rightImageWidth = this._rightImage.getWidth(this);
            g.drawImage(this._rightImage, x + w - rightImageWidth, 0, this);
        }
        super.paint(g);
        if (this._title1 != null) {
            int titleY = 45;
            if (this._title2 != null) {
                titleY = 35;
            }
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            int titleX = this._titleIndent + 10;
            g.setFont(WidgetUtils.FONT_BANNER);
            g.setColor(WidgetUtils.BG_COLOR_DARK);
            g.drawString(this._title1, titleX, titleY);
            if (this._title2 != null) {
                g.setFont(WidgetUtils.FONT_HEADER1);
                g.setColor(WidgetUtils.BG_COLOR_BLUE_MEDIUM);
                g.drawString(this._title2, titleX, titleY += g.getFontMetrics().getHeight());
            }
        }
    }
}

