/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.eobjects.datacleaner.util.WidgetUtils;

public class DCGlassPane {
    private final JFrame _frame;
    private final JPanel _glassPane;
    private final JDialog _dialog;

    public DCGlassPane(JFrame frame) {
        this._frame = frame;
        this._dialog = null;
        this._glassPane = (JPanel)frame.getGlassPane();
        this._glassPane.setLayout(null);
        this._glassPane.setBackground(WidgetUtils.BG_COLOR_DARKEST);
    }

    public DCGlassPane(JDialog dialog) {
        this._frame = null;
        this._dialog = dialog;
        this._glassPane = (JPanel)dialog.getGlassPane();
        this._glassPane.setLayout(null);
        this._glassPane.setBackground(WidgetUtils.BG_COLOR_DARKEST);
    }

    public void showTooltip(final JComponent comp, int timeoutMillis) {
        this.add(comp);
        new Timer(timeoutMillis, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DCGlassPane.this.remove(comp);
            }
        }).start();
    }

    public void add(JComponent comp) {
        this._glassPane.add(comp);
        this._glassPane.setVisible(true);
    }

    public void remove(JComponent comp) {
        Component[] components = this._glassPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (!component.equals(comp)) continue;
            this._glassPane.remove(i);
            break;
        }
        if (this._glassPane.getComponentCount() == 0) {
            this._glassPane.setVisible(false);
        }
    }

    public Dimension getSize() {
        return this.getContentPaneInternal().getSize();
    }

    public void addCentered(JComponent comp) {
        Dimension compSize = comp.getSize();
        Dimension totalSize = this.getSize();
        int x = (totalSize.width - compSize.width) / 2;
        int y = (totalSize.height - compSize.height) / 2;
        comp.setLocation(x, y);
        this.add(comp);
    }

    private Container getContentPaneInternal() {
        if (this._frame == null) {
            return this._dialog.getContentPane();
        }
        return this._frame.getContentPane();
    }

    private JMenuBar getJMenuBarInternal() {
        if (this._frame == null) {
            return this._dialog.getJMenuBar();
        }
        return this._frame.getJMenuBar();
    }

    public boolean isEmpty() {
        return this._glassPane.getComponentCount() == 0;
    }

    public Point getLocationOnScreen() {
        Point contentPaneLocation = this.getContentPaneInternal().getLocationOnScreen();
        int x = contentPaneLocation.x;
        int y = contentPaneLocation.y;
        JMenuBar menuBar = this.getJMenuBarInternal();
        if (menuBar != null) {
            y -= menuBar.getHeight();
        }
        return new Point(x, y);
    }
}

