/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.eobjects.datacleaner.widgets.Alignment;

public class DCPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Image _watermark;
    private final int _imageHeight;
    private final int _imageWidth;
    private final float _horizontalAlignment;
    private final float _verticalAlignment;
    private final Color _bottomColor;
    private final Color _topColor;

    public static DCPanel around(Component component) {
        DCPanel panel = new DCPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(component);
        return panel;
    }

    public static DCPanel flow(Component ... components) {
        return DCPanel.flow(Alignment.LEFT, components);
    }

    public static DCPanel flow(Alignment alignment, Component ... components) {
        return DCPanel.flow(alignment, 10, 2, components);
    }

    public static DCPanel flow(Alignment alignment, int hgap, int vgap, Component ... components) {
        DCPanel panel = new DCPanel();
        panel.setLayout(new FlowLayout(alignment.getFlowLayoutAlignment(), hgap, vgap));
        for (Component component : components) {
            panel.add(component);
        }
        return panel;
    }

    public DCPanel() {
        this(null, 0, 0);
    }

    public DCPanel(Color topColor, Color bottomColor) {
        this(null, 0, 0, topColor, bottomColor);
    }

    public DCPanel(Image watermark, int horizontalAlignmentInPercent, int verticalAlignmentInPercent) {
        this(watermark, horizontalAlignmentInPercent, verticalAlignmentInPercent, null, null);
    }

    public DCPanel(Image watermark, int horizontalAlignmentInPercent, int verticalAlignmentInPercent, Color topColor, Color bottomColor) {
        if (topColor == null || bottomColor == null) {
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
        }
        this._topColor = topColor;
        this._bottomColor = bottomColor;
        this._watermark = watermark;
        this._horizontalAlignment = (float)horizontalAlignmentInPercent / 100.0f;
        this._verticalAlignment = (float)verticalAlignmentInPercent / 100.0f;
        if (watermark != null) {
            ImageIcon icon = new ImageIcon(watermark);
            this._imageWidth = icon.getIconWidth();
            this._imageHeight = icon.getIconHeight();
        } else {
            this._imageWidth = -1;
            this._imageHeight = -1;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int y;
        int x;
        if (this.isOpaque()) {
            x = 0;
            y = 0;
            if (this._topColor == null || this._bottomColor == null) {
                super.paintComponent(g);
            } else {
                GradientPaint paint = new GradientPaint(x, y, this._topColor, x, this.getHeight(), this._bottomColor);
                if (g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setPaint(paint);
                } else {
                    g.setColor(this._bottomColor);
                }
                g.fillRect(x, y, this.getWidth(), this.getHeight());
            }
        }
        if (this._watermark != null) {
            x = this.getWidth() - this._imageWidth;
            x = (int)((float)x * this._horizontalAlignment);
            y = this.getHeight() - this._imageHeight;
            y = (int)((float)y * this._verticalAlignment);
            g.drawImage(this._watermark, x, y, this);
        }
    }

    public DCPanel setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        return this;
    }

    public DCPanel setTitledBorder(String title) {
        this.setBorder(new TitledBorder(title));
        return this;
    }
}

