/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.vfs2.FileObject;
import org.apache.http.client.HttpClient;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.JdbcDatastore;
import org.eobjects.datacleaner.actions.DownloadFilesActionListener;
import org.eobjects.datacleaner.actions.FileDownloadListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.database.DatabaseDriverCatalog;
import org.eobjects.datacleaner.database.DatabaseDriverDescriptor;
import org.eobjects.datacleaner.database.DatabaseDriverState;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.UserDatabaseDriver;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.eobjects.datacleaner.windows.AddDatabaseDriverDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDriversPanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DatabaseDriversPanel.class);
    private final ImageManager imageManager = ImageManager.getInstance();
    private final Set<String> _usedDriverClassNames = new HashSet<String>();
    private final DatabaseDriverCatalog _databaseDriverCatalog;
    private final WindowContext _windowContext;
    private final UserPreferences _userPreferences;
    private final HttpClient _httpClient;

    @Inject
    protected DatabaseDriversPanel(AnalyzerBeansConfiguration configuration, WindowContext windowContext, UserPreferences userPreferences, DatabaseDriverCatalog databaseDriverCatalog, HttpClient httpClient) {
        super(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        String[] datastoreNames;
        this._windowContext = windowContext;
        this._userPreferences = userPreferences;
        this._databaseDriverCatalog = databaseDriverCatalog;
        this._httpClient = httpClient;
        this.setLayout(new BorderLayout());
        DatastoreCatalog datastoreCatalog = configuration.getDatastoreCatalog();
        for (String name : datastoreNames = datastoreCatalog.getDatastoreNames()) {
            String driverClass;
            Datastore datastore = datastoreCatalog.getDatastore(name);
            if (!(datastore instanceof JdbcDatastore) || (driverClass = ((JdbcDatastore)datastore).getDriverClass()) == null) continue;
            this._usedDriverClassNames.add(driverClass);
        }
        this.updateComponents();
    }

    private void updateComponents() {
        this.removeAll();
        JToolBar toolBar = WidgetFactory.createToolBar();
        toolBar.add(WidgetFactory.createToolBarSeparator());
        final JButton addDriverButton = new JButton("Add database driver", this.imageManager.getImageIcon("images/actions/add.png", new ClassLoader[0]));
        addDriverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenu menu = new JMenu("Automatic download and install");
                menu.setIcon(DatabaseDriversPanel.this.imageManager.getImageIcon("images/actions/download.png", new ClassLoader[0]));
                List<DatabaseDriverDescriptor> drivers = DatabaseDriversPanel.this._databaseDriverCatalog.getDatabaseDrivers();
                for (DatabaseDriverDescriptor dd : drivers) {
                    String[] urls = dd.getDownloadUrls();
                    if (urls == null || DatabaseDriversPanel.this._databaseDriverCatalog.getState(dd) != DatabaseDriverState.NOT_INSTALLED) continue;
                    JMenuItem downloadAndInstallMenuItem = WidgetFactory.createMenuItem(dd.getDisplayName(), dd.getIconImagePath());
                    downloadAndInstallMenuItem.addActionListener(DatabaseDriversPanel.this.createDownloadActionListener(dd));
                    menu.add(downloadAndInstallMenuItem);
                }
                if (menu.getMenuComponentCount() == 0) {
                    menu.setEnabled(false);
                }
                JMenuItem localJarFilesMenuItem = WidgetFactory.createMenuItem("Local JAR file(s)...", "images/filetypes/archive.png");
                localJarFilesMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddDatabaseDriverDialog dialog = new AddDatabaseDriverDialog(DatabaseDriversPanel.this._databaseDriverCatalog, DatabaseDriversPanel.this, DatabaseDriversPanel.this._windowContext, DatabaseDriversPanel.this._userPreferences);
                        dialog.setVisible(true);
                    }
                });
                JPopupMenu popup = new JPopupMenu();
                popup.add(menu);
                popup.add(localJarFilesMenuItem);
                popup.show(addDriverButton, 0, addDriverButton.getHeight());
            }
        });
        toolBar.add(addDriverButton);
        DCTable table = this.getDatabaseDriverTable();
        this.add((Component)toolBar, "North");
        this.add((Component)table.toPanel(), "Center");
    }

    public void updateDriverList() {
        this.updateComponents();
    }

    private DCTable getDatabaseDriverTable() {
        List<DatabaseDriverDescriptor> databaseDrivers = this._databaseDriverCatalog.getDatabaseDrivers();
        DefaultTableModel tableModel = new DefaultTableModel(new String[]{"", "Database", "Driver class", "Installed?", "Used?"}, databaseDrivers.size());
        DCTable table = new DCTable(tableModel);
        ImageIcon validIcon = this.imageManager.getImageIcon("images/status/valid.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
        ImageIcon invalidIcon = this.imageManager.getImageIcon("images/status/error.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
        int installedCol = 3;
        int usedCol = 4;
        int row = 0;
        for (DatabaseDriverDescriptor dd : databaseDrivers) {
            String[] downloadUrls;
            String driverClassName = dd.getDriverClassName();
            String displayName = dd.getDisplayName();
            ImageIcon driverIcon = this.imageManager.getImageIcon(DatabaseDriverCatalog.getIconImagePath(dd), IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
            tableModel.setValueAt(driverIcon, row, 0);
            tableModel.setValueAt(displayName, row, 1);
            tableModel.setValueAt(driverClassName, row, 2);
            tableModel.setValueAt("", row, 3);
            tableModel.setValueAt("", row, 4);
            DatabaseDriverState state = this._databaseDriverCatalog.getState(dd);
            if (state == DatabaseDriverState.INSTALLED_WORKING) {
                tableModel.setValueAt(validIcon, row, 3);
            } else if (state == DatabaseDriverState.INSTALLED_NOT_WORKING) {
                tableModel.setValueAt(invalidIcon, row, 3);
            } else if (state == DatabaseDriverState.NOT_INSTALLED && (downloadUrls = dd.getDownloadUrls()) != null) {
                DCPanel buttonPanel = new DCPanel();
                buttonPanel.setLayout(new FlowLayout(1, 4, 0));
                JButton downloadButton = WidgetFactory.createSmallButton("images/actions/download.png");
                downloadButton.setToolTipText("Download and install the driver for " + dd.getDisplayName());
                downloadButton.addActionListener(this.createDownloadActionListener(dd));
                buttonPanel.add(downloadButton);
                tableModel.setValueAt(buttonPanel, row, 3);
            }
            if (this.isUsed(driverClassName)) {
                tableModel.setValueAt(validIcon, row, 4);
            }
            ++row;
        }
        table.setAlignment(3, Alignment.CENTER);
        table.setAlignment(4, Alignment.CENTER);
        table.setRowHeight(IconUtils.ICON_SIZE_SMALL + 4);
        table.getColumn(0).setMaxWidth(IconUtils.ICON_SIZE_SMALL + 4);
        table.getColumn(3).setMaxWidth(84);
        table.getColumn(4).setMaxWidth(70);
        table.setColumnControlVisible(false);
        return table;
    }

    private boolean isUsed(String driverClassName) {
        return this._usedDriverClassNames.contains(driverClassName);
    }

    private ActionListener createDownloadActionListener(final DatabaseDriverDescriptor dd) {
        FileDownloadListener downloadListener = new FileDownloadListener(){

            @Override
            public void onFilesDownloaded(FileObject[] files) {
                String driverClassName = dd.getDriverClassName();
                logger.info("Registering and loading driver '{}' in files '{}'", (Object)driverClassName, (Object)files);
                UserDatabaseDriver userDatabaseDriver = new UserDatabaseDriver(files, driverClassName);
                DatabaseDriversPanel.this._userPreferences.getDatabaseDrivers().add(userDatabaseDriver);
                try {
                    userDatabaseDriver.loadDriver();
                }
                catch (IllegalStateException e) {
                    WidgetUtils.showErrorMessage("Error while loading driver", "Error message: " + e.getMessage(), e);
                }
                DatabaseDriversPanel.this.updateDriverList();
            }
        };
        return new DownloadFilesActionListener(dd.getDownloadUrls(), downloadListener, this._windowContext, this._httpClient, this._userPreferences);
    }
}

