/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import com.google.inject.Injector;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.AccessDatastore;
import org.eobjects.analyzer.connection.CouchDbDatastore;
import org.eobjects.analyzer.connection.CsvDatastore;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.connection.DbaseDatastore;
import org.eobjects.analyzer.connection.ExcelDatastore;
import org.eobjects.analyzer.connection.FixedWidthDatastore;
import org.eobjects.analyzer.connection.JdbcDatastore;
import org.eobjects.analyzer.connection.MongoDbDatastore;
import org.eobjects.analyzer.connection.OdbDatastore;
import org.eobjects.analyzer.connection.SasDatastore;
import org.eobjects.analyzer.connection.XmlDatastore;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.database.DatabaseDriverCatalog;
import org.eobjects.datacleaner.database.DatabaseDriverDescriptor;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.panels.DCGlassPane;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.DatastorePanel;
import org.eobjects.datacleaner.user.DatastoreChangeListener;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DCPopupBubble;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.eobjects.datacleaner.windows.AccessDatastoreDialog;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;
import org.eobjects.datacleaner.windows.CompositeDatastoreDialog;
import org.eobjects.datacleaner.windows.CouchDbDatastoreDialog;
import org.eobjects.datacleaner.windows.CsvDatastoreDialog;
import org.eobjects.datacleaner.windows.DbaseDatastoreDialog;
import org.eobjects.datacleaner.windows.ExcelDatastoreDialog;
import org.eobjects.datacleaner.windows.FixedWidthDatastoreDialog;
import org.eobjects.datacleaner.windows.JdbcDatastoreDialog;
import org.eobjects.datacleaner.windows.MongoDbDatastoreDialog;
import org.eobjects.datacleaner.windows.OdbDatastoreDialog;
import org.eobjects.datacleaner.windows.OptionsDialog;
import org.eobjects.datacleaner.windows.SasDatastoreDialog;
import org.eobjects.datacleaner.windows.XmlDatastoreDialog;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.VerticalLayout;

public class DatastoreListPanel
extends DCPanel
implements DatastoreChangeListener {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final MutableDatastoreCatalog _datastoreCatalog;
    private final AnalysisJobBuilderWindow _analysisJobBuilderWindow;
    private final Provider<OptionsDialog> _optionsDialogProvider;
    private final DatabaseDriverCatalog _databaseDriverCatalog;
    private final List<DatastorePanel> _datastorePanels = new ArrayList<DatastorePanel>();
    private final DCGlassPane _glassPane;
    private final JButton _analyzeButton;
    private final DCPanel _listPanel;
    private final JXTextField _searchDatastoreTextField;
    private final InjectorBuilder _injectorBuilder;

    @Inject
    protected DatastoreListPanel(AnalyzerBeansConfiguration configuration, AnalysisJobBuilderWindow analysisJobBuilderWindow, DCGlassPane glassPane, Provider<OptionsDialog> optionsDialogProvider, InjectorBuilder injectorBuilder, DatabaseDriverCatalog databaseDriverCatalog) {
        this._datastoreCatalog = (MutableDatastoreCatalog)configuration.getDatastoreCatalog();
        this._analysisJobBuilderWindow = analysisJobBuilderWindow;
        this._glassPane = glassPane;
        this._optionsDialogProvider = optionsDialogProvider;
        this._injectorBuilder = injectorBuilder;
        this._databaseDriverCatalog = databaseDriverCatalog;
        this._datastoreCatalog.addListener(this);
        this._analyzeButton = new JButton("Analyze!", imageManager.getImageIcon("images/filetypes/analysis_job.png", new ClassLoader[0]));
        this._analyzeButton.setMargin(new Insets(1, 1, 1, 1));
        this._analyzeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (DatastorePanel datastorePanel : DatastoreListPanel.this._datastorePanels) {
                    if (!datastorePanel.isSelected()) continue;
                    Datastore datastore = datastorePanel.getDatastore();
                    DatastoreConnection dataContextProvider = datastore.openConnection();
                    dataContextProvider.getDataContext().getSchemaNames();
                    DatastoreListPanel.this._analysisJobBuilderWindow.setDatastore(datastore);
                    dataContextProvider.close();
                    return;
                }
            }
        });
        this._searchDatastoreTextField = WidgetFactory.createTextField("Search/filter datastores");
        this._searchDatastoreTextField.setBorder((Border)new CompoundBorder(new EmptyBorder(4, 0, 0, 0), WidgetUtils.BORDER_THIN));
        this._searchDatastoreTextField.setOpaque(false);
        this._searchDatastoreTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                String text = DatastoreListPanel.this._searchDatastoreTextField.getText();
                if (StringUtils.isNullOrEmpty((String)text)) {
                    for (DatastorePanel datastorePanel : DatastoreListPanel.this._datastorePanels) {
                        datastorePanel.setVisible(true);
                    }
                } else {
                    text = text.trim().toLowerCase();
                    Iterator i$ = DatastoreListPanel.this._datastorePanels.iterator();
                    while (i$.hasNext()) {
                        DatastorePanel datastorePanel;
                        String name = (datastorePanel = (DatastorePanel)i$.next()).getDatastore().getName().toLowerCase();
                        datastorePanel.setVisible(name.indexOf(text) != -1);
                    }
                    DatastoreListPanel.this.selectFirstVisibleDatastore();
                }
            }
        });
        this._searchDatastoreTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DatastoreListPanel.this.clickAnalyzeButton();
                } else if (e.getKeyCode() == 40) {
                    DatastoreListPanel.this.selectNextVisibleDatastore();
                } else if (e.getKeyCode() == 38) {
                    DatastoreListPanel.this.selectPreviousVisibleDatastore();
                }
            }
        });
        this.setLayout((LayoutManager)new VerticalLayout(4));
        DCLabel headerLabel = DCLabel.dark("Select datastore for analysis");
        headerLabel.setFont(WidgetUtils.FONT_HEADER1);
        this.add(headerLabel);
        DCLabel createNewDatastoreLabel = DCLabel.dark("Create a new datastore:");
        createNewDatastoreLabel.setFont(WidgetUtils.FONT_HEADER1);
        DCPanel newDatastorePanel = new DCPanel();
        newDatastorePanel.setLayout((LayoutManager)new VerticalLayout(4));
        newDatastorePanel.setBorder(new EmptyBorder(10, 10, 10, 0));
        newDatastorePanel.add(createNewDatastoreLabel);
        newDatastorePanel.add(this.createNewDatastorePanel());
        this.add(newDatastorePanel);
        this._listPanel = new DCPanel();
        this._listPanel.setLayout((LayoutManager)new VerticalLayout(4));
        this._listPanel.setBorder(new EmptyBorder(10, 10, 10, 0));
        this.add(this._listPanel);
        this.updateDatastores();
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout(new FlowLayout(0, 0, 0));
        buttonPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
        buttonPanel.add(this._analyzeButton);
        this.add(buttonPanel);
    }

    private void updateDatastores() {
        Datastore selectedDatastore = this.getSelectedDatastore();
        this._listPanel.removeAll();
        this._datastorePanels.clear();
        DCLabel existingDatastoresLabel = DCLabel.dark("Analyze an existing datastore:");
        existingDatastoresLabel.setFont(WidgetUtils.FONT_HEADER1);
        DCPanel searchDatastorePanel = DCPanel.around((Component)this._searchDatastoreTextField);
        searchDatastorePanel.setBorder(WidgetUtils.BORDER_SHADOW);
        DCPanel headerPanel = new DCPanel();
        headerPanel.setLayout(new FlowLayout(Alignment.LEFT.getFlowLayoutAlignment(), 0, 0));
        headerPanel.add(existingDatastoresLabel);
        headerPanel.add(Box.createHorizontalStrut(20));
        headerPanel.add(searchDatastorePanel);
        this._listPanel.add(headerPanel);
        boolean selectFirst = true;
        String[] datastoreNames = this._datastoreCatalog.getDatastoreNames();
        for (int i = 0; i < datastoreNames.length; ++i) {
            Datastore datastore = this._datastoreCatalog.getDatastore(datastoreNames[i]);
            DatastorePanel datastorePanel = new DatastorePanel(datastore, this._datastoreCatalog, this, this._analysisJobBuilderWindow.getWindowContext(), this._injectorBuilder);
            this._datastorePanels.add(datastorePanel);
            this._listPanel.add(datastorePanel);
            if (selectedDatastore == null || !selectedDatastore.getName().equals(datastore.getName())) continue;
            selectFirst = false;
            this.setSelectedDatastore(datastore);
        }
        if (selectFirst) {
            this.selectFirstVisibleDatastore();
        }
    }

    public void setSelectedDatastore(Datastore datastore) {
        if (datastore != null) {
            for (DatastorePanel panel : this._datastorePanels) {
                if (datastore.equals(panel.getDatastore())) {
                    panel.setSelected(true);
                    continue;
                }
                panel.setSelected(false);
            }
        }
    }

    public Datastore getSelectedDatastore() {
        DatastorePanel datastorePanel = this.getSelectedDatastorePanel();
        if (datastorePanel == null) {
            return null;
        }
        return datastorePanel.getDatastore();
    }

    private DCPanel createNewDatastorePanel() {
        DCPanel panel = new DCPanel();
        panel.setBorder(WidgetUtils.BORDER_LIST_ITEM);
        panel.setLayout(new FlowLayout(0, 10, 10));
        panel.add(this.createNewDatastoreButton("CSV file", "Comma-separated values (CSV) file (or file with other separators)", "images/datastore-types/csv.png", CsvDatastore.class, CsvDatastoreDialog.class));
        panel.add(this.createNewDatastoreButton("Excel spreadsheet", "Microsoft Excel spreadsheet. Either .xls (97-2003) or .xlsx (2007+) format.", "images/datastore-types/excel.png", ExcelDatastore.class, ExcelDatastoreDialog.class));
        panel.add(this.createNewDatastoreButton("Access database", "Microsoft Access database file (.mdb).", "images/datastore-types/access.png", AccessDatastore.class, AccessDatastoreDialog.class));
        panel.add(this.createNewDatastoreButton("SAS library", "A directory of SAS library files (.sas7bdat).", "images/datastore-types/sas.png", SasDatastore.class, SasDatastoreDialog.class));
        panel.add(this.createNewDatastoreButton("DBase database", "DBase database file (.dbf)", "images/datastore-types/dbase.png", DbaseDatastore.class, DbaseDatastoreDialog.class));
        panel.add(this.createNewDatastoreButton("Fixed width file", "Text file with fixed width values. Each value spans a fixed amount of text characters.", "images/datastore-types/fixedwidth.png", FixedWidthDatastore.class, FixedWidthDatastoreDialog.class));
        panel.add(this.createNewDatastoreButton("XML file", "Extensible Markup Language file (.xml)", "images/datastore-types/xml.png", XmlDatastore.class, XmlDatastoreDialog.class));
        panel.add(this.createNewDatastoreButton("OpenOffice.org Base database", "OpenOffice.org Base database file (.odb)", "images/datastore-types/odb.png", OdbDatastore.class, OdbDatastoreDialog.class));
        panel.add(Box.createHorizontalStrut(20));
        panel.add(this.createNewDatastoreButton("MongoDB database", "Connect to a MongoDB database", "images/datastore-types/mongodb.png", MongoDbDatastore.class, MongoDbDatastoreDialog.class));
        panel.add(this.createNewDatastoreButton("CouchDB database", "Connect to a CouchDB database", "images/datastore-types/couchdb.png", CouchDbDatastore.class, CouchDbDatastoreDialog.class));
        final HashSet<String> databaseNames = new HashSet<String>();
        this.createDefaultDatabaseButtons(panel, databaseNames);
        final JButton moreDatastoreTypesButton = new JButton("more");
        moreDatastoreTypesButton.setMargin(new Insets(1, 1, 1, 1));
        moreDatastoreTypesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu popup = new JPopupMenu();
                List<DatabaseDriverDescriptor> databaseDrivers = DatastoreListPanel.this._databaseDriverCatalog.getInstalledWorkingDatabaseDrivers();
                for (DatabaseDriverDescriptor databaseDriver : databaseDrivers) {
                    String databaseName = databaseDriver.getDisplayName();
                    if (databaseNames.contains(databaseName)) continue;
                    String imagePath = databaseDriver.getIconImagePath();
                    ImageIcon icon = imageManager.getImageIcon(imagePath, IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                    JMenuItem menuItem = WidgetFactory.createMenuItem(databaseName, icon);
                    menuItem.addActionListener(DatastoreListPanel.this.createJdbcActionListener(databaseName));
                    popup.add(menuItem);
                }
                ImageIcon icon = imageManager.getImageIcon("images/model/datastore.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                JMenuItem menuItem = WidgetFactory.createMenuItem("Other database", icon);
                menuItem.addActionListener(DatastoreListPanel.this.createJdbcActionListener(null));
                popup.add(menuItem);
                JMenuItem compositeMenuItem = WidgetFactory.createMenuItem("Composite datastore", imageManager.getImageIcon("images/datastore-types/composite.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
                compositeMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        new CompositeDatastoreDialog(DatastoreListPanel.this._datastoreCatalog, DatastoreListPanel.this._analysisJobBuilderWindow.getWindowContext()).setVisible(true);
                    }
                });
                JMenuItem databaseDriversMenuItem = WidgetFactory.createMenuItem("Manage database drivers...", imageManager.getImageIcon("images/menu/options.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
                databaseDriversMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OptionsDialog dialog = (OptionsDialog)DatastoreListPanel.this._optionsDialogProvider.get();
                        dialog.selectDatabaseDriversTab();
                        dialog.setVisible(true);
                    }
                });
                popup.add(databaseDriversMenuItem);
                popup.add(new JSeparator(0));
                popup.add(compositeMenuItem);
                popup.setBorder(WidgetUtils.BORDER_THIN);
                popup.show(moreDatastoreTypesButton, 0, moreDatastoreTypesButton.getHeight());
            }
        });
        panel.add(Box.createHorizontalStrut(10));
        panel.add(moreDatastoreTypesButton);
        return panel;
    }

    private void createDefaultDatabaseButtons(DCPanel panel, Set<String> databaseNames) {
        if (this._databaseDriverCatalog.isInstalled("MySQL")) {
            panel.add(this.createNewJdbcDatastoreButton("MySQL connection", "Connect to a MySQL database", "images/datastore-types/databases/mysql.png", "MySQL", databaseNames));
        }
        if (this._databaseDriverCatalog.isInstalled("PostgreSQL")) {
            panel.add(this.createNewJdbcDatastoreButton("PostgreSQL connection", "Connect to a PostgreSQL database", "images/datastore-types/databases/postgresql.png", "PostgreSQL", databaseNames));
        }
        if (this._databaseDriverCatalog.isInstalled("Oracle")) {
            panel.add(this.createNewJdbcDatastoreButton("Oracle connection", "Connect to a Oracle database", "images/datastore-types/databases/oracle.png", "Oracle", databaseNames));
        }
        if (this._databaseDriverCatalog.isInstalled("Microsoft SQL Server (JTDS)")) {
            panel.add(this.createNewJdbcDatastoreButton("Microsoft SQL Server connection", "Connect to a Microsoft SQL Server database", "images/datastore-types/databases/microsoft.png", "Microsoft SQL Server (JTDS)", databaseNames));
        }
    }

    private <D extends Datastore> JButton createNewDatastoreButton(String title, String description, String imagePath, final Class<D> datastoreClass, final Class<? extends AbstractDialog> dialogClass) {
        ImageIcon icon = imageManager.getImageIcon(imagePath, new ClassLoader[0]);
        JButton button = WidgetFactory.createImageButton(icon);
        DCPopupBubble popupBubble = new DCPopupBubble(this._glassPane, "<html><b>" + title + "</b><br/>" + description + "</html>", 0, 0, imagePath);
        popupBubble.attachTo(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Injector injectorWithNullDatastore = DatastoreListPanel.this._injectorBuilder.with(datastoreClass, null).createInjector();
                AbstractDialog dialog = (AbstractDialog)injectorWithNullDatastore.getInstance(dialogClass);
                dialog.setVisible(true);
            }
        });
        return button;
    }

    private JButton createNewJdbcDatastoreButton(String title, String description, String imagePath, String databaseName, Set<String> databaseNames) {
        databaseNames.add(databaseName);
        ImageIcon icon = imageManager.getImageIcon(imagePath, new ClassLoader[0]);
        JButton button = WidgetFactory.createImageButton(icon);
        DCPopupBubble popupBubble = new DCPopupBubble(this._glassPane, "<html><b>" + title + "</b><br/>" + description + "</html>", 0, 0, imagePath);
        popupBubble.attachTo(button);
        button.addActionListener(this.createJdbcActionListener(databaseName));
        return button;
    }

    private ActionListener createJdbcActionListener(final String databaseName) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Injector injectorWithDatastore = DatastoreListPanel.this._injectorBuilder.with(JdbcDatastore.class, null).createInjector();
                JdbcDatastoreDialog dialog = (JdbcDatastoreDialog)injectorWithDatastore.getInstance(JdbcDatastoreDialog.class);
                dialog.setSelectedDatabase(databaseName);
                dialog.setVisible(true);
            }
        };
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._datastoreCatalog.removeListener(this);
    }

    @Override
    public void onAdd(Datastore datastore) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DatastoreListPanel.this.updateDatastores();
            }
        });
    }

    @Override
    public void onRemove(Datastore datastore) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DatastoreListPanel.this.updateDatastores();
            }
        });
    }

    private void selectFirstVisibleDatastore() {
        boolean found = false;
        for (DatastorePanel datastorePanel : this._datastorePanels) {
            if (!datastorePanel.isVisible()) continue;
            this.setSelectedDatastorePanel(datastorePanel);
            found = true;
            break;
        }
        this._analyzeButton.setEnabled(found);
    }

    private void selectNextVisibleDatastore() {
        DatastorePanel selectedDatastorePanel = this.getSelectedDatastorePanel();
        if (selectedDatastorePanel != null) {
            int indexOf = this._datastorePanels.indexOf(selectedDatastorePanel);
            for (int i = indexOf + 1; i < this._datastorePanels.size(); ++i) {
                DatastorePanel panel = this._datastorePanels.get(i);
                if (!panel.isVisible()) continue;
                this.setSelectedDatastorePanel(panel);
                break;
            }
        }
    }

    private void selectPreviousVisibleDatastore() {
        DatastorePanel selectedDatastorePanel = this.getSelectedDatastorePanel();
        if (selectedDatastorePanel != null) {
            int indexOf = this._datastorePanels.indexOf(selectedDatastorePanel);
            for (int i = indexOf - 1; i >= 0; --i) {
                DatastorePanel panel = this._datastorePanels.get(i);
                if (!panel.isVisible()) continue;
                this.setSelectedDatastorePanel(panel);
                break;
            }
        }
    }

    public void setSelectedDatastorePanel(DatastorePanel datastorePanel) {
        for (DatastorePanel panel : this._datastorePanels) {
            if (datastorePanel == panel) {
                panel.setSelected(true);
                continue;
            }
            panel.setSelected(false);
        }
        this.requestSearchFieldFocus();
    }

    public DatastorePanel getSelectedDatastorePanel() {
        for (DatastorePanel panel : this._datastorePanels) {
            if (!panel.isVisible() || !panel.isSelected()) continue;
            return panel;
        }
        return null;
    }

    public void clickAnalyzeButton() {
        if (this._analyzeButton.isEnabled()) {
            this._analyzeButton.doClick();
        }
    }

    public void requestSearchFieldFocus() {
        this._searchDatastoreTextField.requestFocus();
    }
}

