/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import com.google.inject.Injector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eobjects.analyzer.connection.AccessDatastore;
import org.eobjects.analyzer.connection.CompositeDatastore;
import org.eobjects.analyzer.connection.CouchDbDatastore;
import org.eobjects.analyzer.connection.CsvDatastore;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DbaseDatastore;
import org.eobjects.analyzer.connection.ExcelDatastore;
import org.eobjects.analyzer.connection.FileDatastore;
import org.eobjects.analyzer.connection.FixedWidthDatastore;
import org.eobjects.analyzer.connection.JdbcDatastore;
import org.eobjects.analyzer.connection.MongoDbDatastore;
import org.eobjects.analyzer.connection.OdbDatastore;
import org.eobjects.analyzer.connection.PojoDatastore;
import org.eobjects.analyzer.connection.SasDatastore;
import org.eobjects.analyzer.connection.XmlDatastore;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.DatastoreListPanel;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.windows.AccessDatastoreDialog;
import org.eobjects.datacleaner.windows.CompositeDatastoreDialog;
import org.eobjects.datacleaner.windows.CouchDbDatastoreDialog;
import org.eobjects.datacleaner.windows.CsvDatastoreDialog;
import org.eobjects.datacleaner.windows.DbaseDatastoreDialog;
import org.eobjects.datacleaner.windows.ExcelDatastoreDialog;
import org.eobjects.datacleaner.windows.FixedWidthDatastoreDialog;
import org.eobjects.datacleaner.windows.JdbcDatastoreDialog;
import org.eobjects.datacleaner.windows.MongoDbDatastoreDialog;
import org.eobjects.datacleaner.windows.OdbDatastoreDialog;
import org.eobjects.datacleaner.windows.SasDatastoreDialog;
import org.eobjects.datacleaner.windows.XmlDatastoreDialog;

public class DatastorePanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    public static final int LABEL_MAX_WIDTH = 450;
    private final Datastore _datastore;
    private final MutableDatastoreCatalog _datastoreCatalog;
    private final DatastoreListPanel _datastoreListPanel;
    private final JCheckBox _checkBox;
    private final WindowContext _windowContext;
    private final InjectorBuilder _injectorBuilder;

    public DatastorePanel(Datastore datastore, MutableDatastoreCatalog datastoreCatalog, DatastoreListPanel datastoreListPanel, WindowContext windowContext, InjectorBuilder injectorBuilder) {
        super(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_LESS_BRIGHT);
        this._datastore = datastore;
        this._datastoreCatalog = datastoreCatalog;
        this._datastoreListPanel = datastoreListPanel;
        this._windowContext = windowContext;
        this._injectorBuilder = injectorBuilder;
        this.setOpaque(false);
        Icon icon = IconUtils.getDatastoreIcon(datastore);
        String description = DatastorePanel.getDescription(datastore);
        this._checkBox = new JCheckBox();
        this._checkBox.setOpaque(false);
        this._checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatastorePanel.this._datastoreListPanel.setSelectedDatastorePanel(DatastorePanel.this);
            }
        });
        this._checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DatastorePanel.this.setOpaque(DatastorePanel.this.isSelected());
                DatastorePanel.this.updateUI();
            }
        });
        String datastoreName = datastore.getName();
        DCLabel datastoreNameLabel = DCLabel.dark("<html><b>" + datastoreName + "</b><br/>" + description + "</html>");
        datastoreNameLabel.setIconTextGap(10);
        datastoreNameLabel.setIcon(icon);
        datastoreNameLabel.setMaximumWidth(450);
        MouseAdapter invokeCheckBoxMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DatastorePanel.this._checkBox.doClick();
                DatastorePanel.this._datastoreListPanel.requestSearchFieldFocus();
                if (e.getClickCount() > 1) {
                    DatastorePanel.this._datastoreListPanel.clickAnalyzeButton();
                }
            }
        };
        this.addMouseListener(invokeCheckBoxMouseListener);
        datastoreNameLabel.addMouseListener(invokeCheckBoxMouseListener);
        JButton editButton = this.createEditButton(datastore);
        JButton removeButton = this.createRemoveButton(datastore);
        this.setBorder(WidgetUtils.BORDER_LIST_ITEM);
        WidgetUtils.addToGridBag((Component)DCPanel.flow(this._checkBox, datastoreNameLabel), (JPanel)this, 0, 0, 17, 1.0, 1.0);
        WidgetUtils.addToGridBag(editButton, this, 1, 0, 13);
        WidgetUtils.addToGridBag(removeButton, this, 2, 0, 13);
    }

    public Datastore getDatastore() {
        return this._datastore;
    }

    private JButton createRemoveButton(final Datastore datastore) {
        final String name = datastore.getName();
        JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
        removeButton.setToolTipText("Remove datastore");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(DatastorePanel.this, "Are you sure you wish to remove the datastore '" + name + "'?", "Confirm remove", 0);
                if (result == 0) {
                    DatastorePanel.this._datastoreCatalog.removeDatastore(datastore);
                }
            }
        });
        if (!this._datastoreCatalog.isDatastoreMutable(name)) {
            removeButton.setEnabled(false);
        }
        return removeButton;
    }

    private JButton createEditButton(final Datastore datastore) {
        JButton editButton = WidgetFactory.createSmallButton("images/actions/edit.png");
        editButton.setToolTipText("Edit datastore");
        if (datastore instanceof JdbcDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injectorWithDatastore = DatastorePanel.this._injectorBuilder.with(JdbcDatastore.class, (Object)datastore).createInjector();
                    JdbcDatastoreDialog dialog = (JdbcDatastoreDialog)injectorWithDatastore.getInstance(JdbcDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof CsvDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = DatastorePanel.this._injectorBuilder.with(CsvDatastore.class, (Object)datastore).createInjector();
                    CsvDatastoreDialog dialog = (CsvDatastoreDialog)injector.getInstance(CsvDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof AccessDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = DatastorePanel.this._injectorBuilder.with(AccessDatastore.class, (Object)datastore).createInjector();
                    AccessDatastoreDialog dialog = (AccessDatastoreDialog)injector.getInstance(AccessDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof ExcelDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = DatastorePanel.this._injectorBuilder.with(ExcelDatastore.class, (Object)datastore).createInjector();
                    ExcelDatastoreDialog dialog = (ExcelDatastoreDialog)injector.getInstance(ExcelDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof SasDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = DatastorePanel.this._injectorBuilder.with(SasDatastore.class, (Object)datastore).createInjector();
                    SasDatastoreDialog dialog = (SasDatastoreDialog)injector.getInstance(SasDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof XmlDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = DatastorePanel.this._injectorBuilder.with(XmlDatastore.class, (Object)datastore).createInjector();
                    XmlDatastoreDialog dialog = (XmlDatastoreDialog)injector.getInstance(XmlDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof OdbDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = DatastorePanel.this._injectorBuilder.with(OdbDatastore.class, (Object)datastore).createInjector();
                    OdbDatastoreDialog dialog = (OdbDatastoreDialog)injector.getInstance(OdbDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof FixedWidthDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = DatastorePanel.this._injectorBuilder.with(FixedWidthDatastore.class, (Object)datastore).createInjector();
                    FixedWidthDatastoreDialog dialog = (FixedWidthDatastoreDialog)injector.getInstance(FixedWidthDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof DbaseDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = DatastorePanel.this._injectorBuilder.with(DbaseDatastore.class, (Object)datastore).createInjector();
                    DbaseDatastoreDialog dialog = (DbaseDatastoreDialog)injector.getInstance(DbaseDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof CouchDbDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = DatastorePanel.this._injectorBuilder.with(CouchDbDatastore.class, (Object)datastore).createInjector();
                    CouchDbDatastoreDialog dialog = (CouchDbDatastoreDialog)injector.getInstance(CouchDbDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof MongoDbDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = DatastorePanel.this._injectorBuilder.with(MongoDbDatastore.class, (Object)datastore).createInjector();
                    MongoDbDatastoreDialog dialog = (MongoDbDatastoreDialog)injector.getInstance(MongoDbDatastoreDialog.class);
                    dialog.setVisible(true);
                }
            });
        } else if (datastore instanceof CompositeDatastore) {
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompositeDatastoreDialog dialog = new CompositeDatastoreDialog((CompositeDatastore)datastore, DatastorePanel.this._datastoreCatalog, DatastorePanel.this._windowContext);
                    dialog.setVisible(true);
                }
            });
        } else {
            editButton.setEnabled(false);
        }
        if (!this._datastoreCatalog.isDatastoreMutable(datastore.getName())) {
            editButton.setEnabled(false);
        }
        return editButton;
    }

    private static String getDescription(Datastore datastore) {
        if (datastore.getDescription() != null) {
            return datastore.getDescription();
        }
        if (datastore instanceof FileDatastore) {
            return ((FileDatastore)datastore).getFilename();
        }
        if (datastore instanceof JdbcDatastore) {
            JdbcDatastore jdbcDatastore = (JdbcDatastore)datastore;
            String jdbcUrl = jdbcDatastore.getJdbcUrl();
            String datasourceJndiUrl = jdbcDatastore.getDatasourceJndiUrl();
            if (StringUtils.isNullOrEmpty((String)datasourceJndiUrl)) {
                return jdbcUrl;
            }
            return datasourceJndiUrl;
        }
        if (datastore instanceof MongoDbDatastore) {
            MongoDbDatastore mongoDbDatastore = (MongoDbDatastore)datastore;
            return mongoDbDatastore.getHostname() + ":" + mongoDbDatastore.getPort() + " - " + mongoDbDatastore.getDatabaseName();
        }
        if (datastore instanceof CouchDbDatastore) {
            CouchDbDatastore couchDbDatastore = (CouchDbDatastore)datastore;
            return (couchDbDatastore.isSslEnabled() ? "https://" : "http://") + couchDbDatastore.getHostname() + ":" + couchDbDatastore.getPort();
        }
        if (datastore instanceof PojoDatastore) {
            return "In-memory collection of records.";
        }
        if (datastore instanceof CompositeDatastore) {
            List datastores = ((CompositeDatastore)datastore).getDatastores();
            StringBuilder sb = new StringBuilder();
            for (Datastore ds : datastores) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(ds.getName());
            }
            return sb.toString();
        }
        return "";
    }

    public boolean isSelected() {
        return this._checkBox.isSelected();
    }

    public void setSelected(boolean selected) {
        this._checkBox.setSelected(selected);
    }
}

