/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import com.google.inject.Injector;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.reference.DatastoreDictionary;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.SimpleDictionary;
import org.eobjects.analyzer.reference.TextFileDictionary;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.panels.DCGlassPane;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.DictionaryChangeListener;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DCPopupBubble;
import org.eobjects.datacleaner.widgets.HelpIcon;
import org.eobjects.datacleaner.windows.DatastoreDictionaryDialog;
import org.eobjects.datacleaner.windows.SimpleDictionaryDialog;
import org.eobjects.datacleaner.windows.TextFileDictionaryDialog;
import org.jdesktop.swingx.VerticalLayout;

public class DictionaryListPanel
extends DCPanel
implements DictionaryChangeListener {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final AnalyzerBeansConfiguration _configuration;
    private final MutableReferenceDataCatalog _catalog;
    private final DCPanel _listPanel;
    private final DCGlassPane _glassPane;
    private final InjectorBuilder _injectorBuilder;

    @Inject
    protected DictionaryListPanel(DCGlassPane glassPane, AnalyzerBeansConfiguration configuration, InjectorBuilder injectorBuilder) {
        super(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        this._glassPane = glassPane;
        this._configuration = configuration;
        this._injectorBuilder = injectorBuilder;
        this._catalog = (MutableReferenceDataCatalog)this._configuration.getReferenceDataCatalog();
        this._catalog.addDictionaryListener(this);
        this._listPanel = new DCPanel();
        this._listPanel.setLayout((LayoutManager)new VerticalLayout(4));
        this.updateComponents();
        DCLabel newDictionariesLabel = DCLabel.dark("Create new dictionary:");
        newDictionariesLabel.setFont(WidgetUtils.FONT_HEADER1);
        DCLabel existingDictionariesLabel = DCLabel.dark("Existing dictionaries:");
        existingDictionariesLabel.setFont(WidgetUtils.FONT_HEADER1);
        this.setLayout((LayoutManager)new VerticalLayout(10));
        this.add(newDictionariesLabel);
        this.add(this.createNewDictionariesPanel());
        this.add(Box.createVerticalStrut(10));
        this.add(existingDictionariesLabel);
        this.setBorder(new EmptyBorder(10, 10, 10, 0));
        this.add(this._listPanel);
    }

    private DCPanel createNewDictionariesPanel() {
        JButton textFileDictionaryButton = this.createButton("images/model/dictionary_textfile.png", "<html><b>Text file dictionary</b><br/>A dictionary based on a text file on your filesystem.</html>");
        textFileDictionaryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Injector injector = DictionaryListPanel.this._injectorBuilder.with(TextFileDictionary.class, null).createInjector();
                TextFileDictionaryDialog dialog = (TextFileDictionaryDialog)injector.getInstance(TextFileDictionaryDialog.class);
                dialog.open();
            }
        });
        JButton simpleDictionaryButton = this.createButton("images/model/dictionary_simple.png", "<html><b>Simple dictionary</b><br/>A dictionary written and stored directly in DataCleaner.</html>");
        simpleDictionaryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Injector injector = DictionaryListPanel.this._injectorBuilder.with(SimpleDictionary.class, null).createInjector();
                SimpleDictionaryDialog dialog = (SimpleDictionaryDialog)injector.getInstance(SimpleDictionaryDialog.class);
                dialog.open();
            }
        });
        JButton datastoreDictionaryButton = this.createButton("images/model/dictionary_datastore.png", "<html><b>Datastore dictionary</b><br/>Dictionary based on a column in a datastore.</html>");
        datastoreDictionaryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Injector injector = DictionaryListPanel.this._injectorBuilder.with(DatastoreDictionary.class, null).createInjector();
                DatastoreDictionaryDialog dialog = (DatastoreDictionaryDialog)injector.getInstance(DatastoreDictionaryDialog.class);
                dialog.open();
            }
        });
        HelpIcon helpIcon = new HelpIcon("<b>Dictionaries</b><br>A dictionary is a set of values that grouped together represent a named set of values,for example valid values or blacklisted values for a given type of data.<br>Dictionaries can be used throughout DataCleaner for filtering, matching and more.");
        DCPanel panel = DCPanel.flow(textFileDictionaryButton, simpleDictionaryButton, datastoreDictionaryButton, Box.createHorizontalStrut(100), helpIcon);
        panel.setBorder(WidgetUtils.BORDER_LIST_ITEM);
        return panel;
    }

    private JButton createButton(String imagePath, String description) {
        JButton button = WidgetFactory.createImageButton(imageManager.getImageIcon(imagePath, new ClassLoader[0]));
        DCPopupBubble popupBubble = new DCPopupBubble(this._glassPane, description, 0, 0, imagePath);
        popupBubble.attachTo(button);
        return button;
    }

    private void updateComponents() {
        this._listPanel.removeAll();
        Object[] names = this._catalog.getDictionaryNames();
        Arrays.sort(names);
        ImageIcon icon = imageManager.getImageIcon("images/model/dictionary.png", new ClassLoader[0]);
        for (Object name : names) {
            final Dictionary dictionary = this._catalog.getDictionary((String)name);
            DCLabel dictLabel = DCLabel.dark("<html><b>" + (String)name + "</b><br/>" + DictionaryListPanel.getDescription(dictionary) + "</html>");
            dictLabel.setIcon(icon);
            dictLabel.setMaximumWidth(280);
            JButton editButton = WidgetFactory.createSmallButton("images/actions/edit.png");
            editButton.setToolTipText("Edit dictionary");
            if (dictionary instanceof DatastoreDictionary) {
                editButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Injector injector = DictionaryListPanel.this._injectorBuilder.with(DatastoreDictionary.class, (Object)dictionary).createInjector();
                        DatastoreDictionaryDialog dialog = (DatastoreDictionaryDialog)injector.getInstance(DatastoreDictionaryDialog.class);
                        dialog.open();
                    }
                });
            } else if (dictionary instanceof TextFileDictionary) {
                editButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Injector injector = DictionaryListPanel.this._injectorBuilder.with(TextFileDictionary.class, (Object)dictionary).createInjector();
                        TextFileDictionaryDialog dialog = (TextFileDictionaryDialog)injector.getInstance(TextFileDictionaryDialog.class);
                        dialog.open();
                    }
                });
            } else if (dictionary instanceof SimpleDictionary) {
                editButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Injector injector = DictionaryListPanel.this._injectorBuilder.with(SimpleDictionary.class, (Object)dictionary).createInjector();
                        SimpleDictionaryDialog dialog = (SimpleDictionaryDialog)injector.getInstance(SimpleDictionaryDialog.class);
                        dialog.open();
                    }
                });
            } else {
                editButton.setEnabled(false);
            }
            JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
            removeButton.setToolTipText("Remove dictionary");
            removeButton.addActionListener(new ActionListener((String)name, dictionary){
                final /* synthetic */ String val$name;
                final /* synthetic */ Dictionary val$dictionary;
                {
                    this.val$name = string;
                    this.val$dictionary = dictionary;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = JOptionPane.showConfirmDialog(DictionaryListPanel.this, "Are you sure you wish to remove the dictionary '" + this.val$name + "'?", "Confirm remove", 0);
                    if (result == 0) {
                        DictionaryListPanel.this._catalog.removeDictionary(this.val$dictionary);
                    }
                }
            });
            if (!this._catalog.isDictionaryMutable((String)name)) {
                editButton.setEnabled(false);
                removeButton.setEnabled(false);
            }
            DCPanel dictionaryPanel = new DCPanel();
            dictionaryPanel.setBorder(WidgetUtils.BORDER_LIST_ITEM);
            WidgetUtils.addToGridBag((Component)dictLabel, (JPanel)dictionaryPanel, 0, 0, 1.0, 0.0);
            WidgetUtils.addToGridBag(editButton, dictionaryPanel, 1, 0, 13);
            WidgetUtils.addToGridBag(removeButton, dictionaryPanel, 2, 0, 13);
            this._listPanel.add(dictionaryPanel);
        }
        if (names.length == 0) {
            this._listPanel.add(DCLabel.dark("(none)"));
        }
        this.updateUI();
    }

    private static String getDescription(Dictionary dictionary) {
        if (dictionary.getDescription() != null) {
            return dictionary.getDescription();
        }
        if (dictionary instanceof TextFileDictionary) {
            return ((TextFileDictionary)dictionary).getFilename();
        }
        if (dictionary instanceof DatastoreDictionary) {
            DatastoreDictionary datastoreDictionary = (DatastoreDictionary)dictionary;
            return datastoreDictionary.getDatastoreName() + ": " + datastoreDictionary.getQualifiedColumnName();
        }
        if (dictionary instanceof SimpleDictionary) {
            Collection values = dictionary.getValues().getValues();
            StringBuilder sb = new StringBuilder();
            for (String value : values) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(value);
                if (sb.length() <= 20) continue;
                break;
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public void onAdd(Dictionary dictionary) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DictionaryListPanel.this.updateComponents();
            }
        });
    }

    @Override
    public void onRemove(Dictionary dictionary) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DictionaryListPanel.this.updateComponents();
            }
        });
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._catalog.removeDictionaryListener(this);
    }
}

