/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import cern.colt.Arrays;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.ExtensionPackage;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.ExtensionFilter;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCFileChooser;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.action.OpenBrowserAction;

public class ExtensionPackagesPanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private final UserPreferences _userPreferences;
    private final ImageManager imageManager = ImageManager.getInstance();
    private final AnalyzerBeansConfiguration _configuration;

    @Inject
    protected ExtensionPackagesPanel(AnalyzerBeansConfiguration configuration, UserPreferences userPreferences) {
        super(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        this._configuration = configuration;
        this._userPreferences = userPreferences;
        this.setLayout(new BorderLayout());
        this.updateComponents();
    }

    private void updateComponents() {
        this.removeAll();
        final List<ExtensionPackage> extensionPackages = this._userPreferences.getExtensionPackages();
        final JButton addExtensionButton = new JButton("Add extension package", this.imageManager.getImageIcon("images/actions/add.png", new ClassLoader[0]));
        addExtensionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem extensionSwapMenuItem = new JMenuItem("Browse the ExtensionSwap", ExtensionPackagesPanel.this.imageManager.getImageIcon("images/actions/website.png", new ClassLoader[0]));
                extensionSwapMenuItem.addActionListener((ActionListener)new OpenBrowserAction("http://datacleaner.org/extensions"));
                JMenuItem manualInstallMenuItem = new JMenuItem("Manually install JAR file", ExtensionPackagesPanel.this.imageManager.getImageIcon("images/filetypes/archive.png", new ClassLoader[0]));
                manualInstallMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DCFileChooser fileChooser = new DCFileChooser(ExtensionPackagesPanel.this._userPreferences.getConfiguredFileDirectory());
                        fileChooser.setMultiSelectionEnabled(true);
                        fileChooser.setFileFilter(new ExtensionFilter("DataCleaner extension JAR file (.jar)", ".jar"));
                        int result = fileChooser.showOpenDialog(ExtensionPackagesPanel.this);
                        if (result == 0) {
                            File[] files = fileChooser.getSelectedFiles();
                            String suggestedPackageName = ExtensionPackage.autoDetectPackageName(files[0]);
                            String packageName = JOptionPane.showInputDialog("Please provide the package name of the extension", (Object)suggestedPackageName);
                            StringBuilder extensionNameBuilder = new StringBuilder();
                            for (File file : files) {
                                if (extensionNameBuilder.length() > 0) {
                                    extensionNameBuilder.append(", ");
                                }
                                extensionNameBuilder.append(file.getName());
                            }
                            String extensionName = extensionNameBuilder.toString();
                            ExtensionPackage userExtensionPackage = new ExtensionPackage(extensionName, packageName, true, files);
                            userExtensionPackage.loadDescriptors(ExtensionPackagesPanel.this._configuration.getDescriptorProvider());
                            extensionPackages.add(userExtensionPackage);
                            ExtensionPackagesPanel.this.updateComponents();
                        }
                    }
                });
                JPopupMenu popup = new JPopupMenu("Add extension");
                popup.add(extensionSwapMenuItem);
                popup.add(manualInstallMenuItem);
                popup.show(addExtensionButton, 0, addExtensionButton.getHeight());
            }
        });
        JToolBar toolBar = WidgetFactory.createToolBar();
        toolBar.add(WidgetFactory.createToolBarSeparator());
        toolBar.add(addExtensionButton);
        DCPanel listPanel = new DCPanel();
        listPanel.setLayout((LayoutManager)new VerticalLayout(4));
        listPanel.setBorder(new EmptyBorder(0, 10, 10, 0));
        ImageIcon pluginIcon = this.imageManager.getImageIcon("images/component-types/plugin.png", new ClassLoader[0]);
        ImageIcon errorIcon = this.imageManager.getImageIcon("images/status/error.png", new ClassLoader[0]);
        for (final ExtensionPackage extensionPackage : extensionPackages) {
            DCLabel extensionLabel;
            Object[] files = extensionPackage.getFiles();
            boolean valid = true;
            for (File file : files) {
                if (file.exists()) continue;
                valid = false;
            }
            if (valid) {
                extensionLabel = DCLabel.dark("<html><b>" + extensionPackage.getName() + "</b><br/>Loaded: " + extensionPackage.getLoadedAnalyzers() + " Analyzers, " + extensionPackage.getLoadedTransformers() + " Transformers, " + extensionPackage.getLoadedFilters() + " Filters.<br/>Root package: '" + extensionPackage.getScanPackage() + "'.</html>");
                extensionLabel.setIcon(pluginIcon);
            } else {
                extensionLabel = DCLabel.dark("<html><b>" + extensionPackage.getName() + "</b><br/>Error loading extension files:<br/>" + Arrays.toString((Object[])files) + "</html>");
                extensionLabel.setIcon(errorIcon);
            }
            final JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
            removeButton.setToolTipText("Remove extension");
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    extensionPackages.remove(extensionPackage);
                    removeButton.setEnabled(false);
                    extensionLabel.setText("*** Removal requires application restart ***");
                }
            });
            DCPanel extensionPanel = new DCPanel();
            extensionPanel.setBorder(WidgetUtils.BORDER_LIST_ITEM);
            WidgetUtils.addToGridBag((Component)extensionLabel, (JPanel)extensionPanel, 0, 0, 1.0, 0.0);
            WidgetUtils.addToGridBag(removeButton, extensionPanel, 1, 0, 13);
            listPanel.add(extensionPanel);
        }
        if (extensionPackages.isEmpty()) {
            listPanel.add(DCLabel.dark("(none)"));
        }
        this.add((Component)toolBar, "North");
        this.add((Component)listPanel, "Center");
        this.updateUI();
    }
}

