/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.datacleaner.actions.DisplayOptionsForFilterOutcomeActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.AbstractJobBuilderPanel;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.FilterJobBuilderPresenter;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;

public class FilterJobBuilderPanel
extends AbstractJobBuilderPanel
implements FilterJobBuilderPresenter {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private static final Image WATERMARK_IMAGE = imageManager.getImage("images/window/transformer-tab-background.png", new ClassLoader[0]);
    private final FilterJobBuilder<?, ?> _filterJobBuilder;
    private final DCPanel _outcomePanel;

    public FilterJobBuilderPanel(FilterJobBuilder<?, ?> filterJobBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory) {
        this(WATERMARK_IMAGE, 95, 95, filterJobBuilder, windowContext, propertyWidgetFactory);
    }

    protected FilterJobBuilderPanel(Image watermarkImage, int watermarkHorizontalPosition, int watermarkVerticalPosition, FilterJobBuilder<?, ?> filterJobBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory) {
        super(watermarkImage, watermarkHorizontalPosition, watermarkVerticalPosition, (AbstractBeanJobBuilder<?, ?, ?>)filterJobBuilder, propertyWidgetFactory);
        this._filterJobBuilder = filterJobBuilder;
        this._outcomePanel = new DCPanel();
        Set categoryNames = ((FilterBeanDescriptor)this._filterJobBuilder.getDescriptor()).getOutcomeCategoryNames();
        for (String categoryName : categoryNames) {
            JButton outcomeButton = new JButton(categoryName, imageManager.getImageIcon("images/component-types/filter-outcome.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            outcomeButton.addActionListener(new DisplayOptionsForFilterOutcomeActionListener(this._filterJobBuilder, categoryName));
            this._outcomePanel.add(outcomeButton);
        }
        JButton helpButton = WidgetFactory.createSmallButton("images/widgets/help.png");
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DCPanel messagePanel = new DCPanel();
                messagePanel.setLayout(new BorderLayout());
                messagePanel.add((Component)new JLabel(imageManager.getImageIcon("images/help/help_requirement_mapping.png", new ClassLoader[0])), "West");
                messagePanel.add(DCLabel.darkMultiLine("Filter outcomes can be set as requirements<br>for other components, using the<br>\"(no requirement specified)\" buttons.<br><br>You can also click the categories directly to eg.<br>write categorized records or to map them<br>as requirements for existing or new components."));
                JOptionPane.showMessageDialog(FilterJobBuilderPanel.this, messagePanel, "Help: Filter categories / outcomes", -1);
            }
        });
        this._outcomePanel.add(helpButton);
    }

    @Override
    protected JComponent decorate(DCPanel panel) {
        JComponent result = super.decorate(panel);
        this.addTaskPane(imageManager.getImageIcon("images/component-types/filter-outcome.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]), "This filter categorizes records as...", this._outcomePanel);
        return result;
    }

    @Override
    public FilterJobBuilder<?, ?> getJobBuilder() {
        return this._filterJobBuilder;
    }
}

