/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.actions.LoginChangeListener;
import org.eobjects.datacleaner.actions.MoveComponentTimerActionListener;
import org.eobjects.datacleaner.panels.DCGlassPane;
import org.eobjects.datacleaner.user.AuthenticationService;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.HumanInferenceToolbarButton;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.action.OpenBrowserAction;

public class LoginPanel
extends JPanel
implements LoginChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 360;
    private static final int POSITION_Y = 130;
    private final AuthenticationService _authenticationService;
    private final DCGlassPane _glassPane;
    private final int _alpha = 220;
    private final int _margin = 0;
    private final Color _background = WidgetUtils.BG_COLOR_DARKEST;
    private final Color _foreground = WidgetUtils.BG_COLOR_BRIGHTEST;
    private final Color _borderColor = WidgetUtils.BG_COLOR_MEDIUM;
    private final UserPreferences _userPreferences;

    public LoginPanel(AuthenticationService authenticationService, DCGlassPane glassPane, UserPreferences userPreferences) {
        this._authenticationService = authenticationService;
        this._glassPane = glassPane;
        this._userPreferences = userPreferences;
        this.setOpaque(false);
        this.setBorder(new CompoundBorder(new LineBorder(this._borderColor, 1), new EmptyBorder(20, 20, 20, 30)));
        this.setVisible(false);
        this.setSize(360, 400);
        this.setLocation(this.getXWhenOut(), 130);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateContents();
        this._userPreferences.addLoginChangeListener(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._userPreferences.removeLoginChangeListener(this);
    }

    private int getXWhenOut() {
        return this._glassPane.getSize().width + 360 + 10;
    }

    private int getXWhenIn() {
        return this._glassPane.getSize().width - 360 + 10;
    }

    public void moveIn(int delay) {
        this.setLocation(this.getXWhenOut(), 130);
        this.setVisible(true);
        this._glassPane.add(this);
        Timer timer = new Timer(10, new MoveComponentTimerActionListener(this, this.getXWhenIn(), 130, 40){

            @Override
            protected void done() {
            }
        });
        timer.setInitialDelay(delay);
        timer.start();
    }

    public void moveOut(int delay) {
        Timer timer = new Timer(10, new MoveComponentTimerActionListener(this, this.getXWhenOut(), 130, 40){

            @Override
            protected void done() {
                LoginPanel loginPanel = LoginPanel.this;
                loginPanel.setVisible(false);
                LoginPanel.this._glassPane.remove(loginPanel);
            }
        });
        timer.setInitialDelay(delay);
        timer.start();
    }

    @Override
    public Color getBackground() {
        return this._background;
    }

    @Override
    public Color getForeground() {
        return this._foreground;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int x = 0;
        int y = 0;
        int w = this.getWidth() - 0;
        int h = this.getHeight() - 0;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color bg = this.getBackground();
        Color bgWithAlpha = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), this.getAlpha());
        g2.setColor(bgWithAlpha);
        g2.fillRect(x, y, w, h);
        g2.dispose();
    }

    private int getAlpha() {
        return 220;
    }

    private void updateContents() {
        this.removeAll();
        if (this._userPreferences.isLoggedIn()) {
            JLabel loggedInLabel = new JLabel("Logged in as: " + this._userPreferences.getUsername());
            loggedInLabel.setForeground(this.getForeground());
            WidgetUtils.addToGridBag(new JLabel(ImageManager.getInstance().getImageIcon("images/status/valid.png", new ClassLoader[0])), this, 0, 0);
            WidgetUtils.addToGridBag(loggedInLabel, this, 0, 1);
        } else {
            final JXTextField usernameTextField = WidgetFactory.createTextField(null, 15);
            final JPasswordField passwordTextField = WidgetFactory.createPasswordField(15);
            JButton registerButton = WidgetFactory.createButton("Register", "images/actions/website.png");
            registerButton.addActionListener((ActionListener)new OpenBrowserAction("http://datacleaner.org/?register"));
            JButton loginButton = WidgetFactory.createButton("Login", "images/actions/login.png");
            loginButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String username = usernameTextField.getText();
                    char[] password = passwordTextField.getPassword();
                    if (StringUtils.isNullOrEmpty((String)username) || password == null || password.length == 0) {
                        JOptionPane.showMessageDialog(LoginPanel.this, "Please enter a username and a password.", "Invalid credentials", 0);
                    } else {
                        boolean authenticated = LoginPanel.this._authenticationService.auth(username, password);
                        if (authenticated) {
                            LoginPanel.this._userPreferences.setUsername(username);
                            LoginPanel.this.updateContents();
                            LoginPanel.this.moveOut(1000);
                        } else {
                            JOptionPane.showMessageDialog(LoginPanel.this, "The entered username and password was incorrect.", "Invalid credentials", 0);
                        }
                    }
                }
            });
            JButton cancelButton = WidgetFactory.createButton("Cancel", "images/actions/back.png");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoginPanel.this.moveOut(500);
                }
            });
            int y = 0;
            String loginInfo = "Thank you for using DataCleaner. We kindly ask you to identify yourself by providing us with your eobjects.org user credentials.<br><br>If you are not registered yet, we hope that you will do so now, giving the DataCleaner development community a better sense of it's users and audience.<br><br>By logging in, you also accept transmitting very simple usage statistics to the DataCleaner community, signaling which features you are using.";
            DCLabel loginInfoLabel = DCLabel.brightMultiLine("Thank you for using DataCleaner. We kindly ask you to identify yourself by providing us with your eobjects.org user credentials.<br><br>If you are not registered yet, we hope that you will do so now, giving the DataCleaner development community a better sense of it's users and audience.<br><br>By logging in, you also accept transmitting very simple usage statistics to the DataCleaner community, signaling which features you are using.");
            loginInfoLabel.setSize(300, 250);
            loginInfoLabel.setPreferredSize(new Dimension(300, 250));
            WidgetUtils.addToGridBag(loginInfoLabel, this, 0, y, 2, 1, 10, 0, 1.0, 1.0);
            WidgetUtils.addToGridBag(Box.createVerticalStrut(4), (JPanel)this, 0, ++y, 2, 1);
            JLabel usernameLabel = new JLabel("Username:");
            usernameLabel.setForeground(this.getForeground());
            WidgetUtils.addToGridBag(usernameLabel, this, 0, ++y);
            WidgetUtils.addToGridBag((Component)usernameTextField, this, 1, y);
            JLabel passwordLabel = new JLabel("Password:");
            passwordLabel.setForeground(this.getForeground());
            WidgetUtils.addToGridBag(passwordLabel, this, 0, ++y);
            WidgetUtils.addToGridBag(passwordTextField, this, 1, y);
            WidgetUtils.addToGridBag(Box.createVerticalStrut(10), (JPanel)this, 0, ++y, 2, 1);
            ++y;
            JToolBar buttonPanel = WidgetFactory.createToolBar();
            buttonPanel.add(registerButton);
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(loginButton);
            buttonPanel.add(Box.createHorizontalStrut(4));
            buttonPanel.add(cancelButton);
            WidgetUtils.addToGridBag((Component)buttonPanel, (JPanel)this, 0, y, 2, 1);
            WidgetUtils.addToGridBag(Box.createVerticalStrut(10), (JPanel)this, 0, ++y, 2, 1);
            WidgetUtils.addToGridBag((Component)new HumanInferenceToolbarButton(), (JPanel)this, 0, ++y, 2, 1);
        }
        this.updateUI();
    }

    @Override
    public void onLoginStateChanged(boolean loggedIn, String username) {
        this.updateContents();
    }
}

