/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableModel;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.SourceColumnChangeListener;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.eobjects.metamodel.schema.Column;

public class MetadataPanel
extends DCPanel
implements SourceColumnChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Table", "Column", "Type", "Native type", "Size", "Nullable?", "Indexed?"};
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final DCTable _table;

    @Inject
    protected MetadataPanel(AnalysisJobBuilder analysisJobBuilder) {
        super(ImageManager.getInstance().getImage("images/window/metadata-tab-background.png", new ClassLoader[0]), 95, 95, WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        this._analysisJobBuilder = analysisJobBuilder;
        this._analysisJobBuilder.getSourceColumnListeners().add(this);
        this._table = new DCTable(COLUMN_NAMES);
        this._table.setAlignment(4, Alignment.RIGHT);
        this._table.setAlignment(5, Alignment.CENTER);
        this._table.setAlignment(6, Alignment.CENTER);
        this.setLayout(new BorderLayout());
        DCPanel tablePanel = this._table.toPanel();
        tablePanel.setBorder(new CompoundBorder(WidgetUtils.BORDER_SHADOW, WidgetUtils.BORDER_THIN));
        this.add((Component)tablePanel, "Center");
        this.updateComponents();
    }

    private void updateComponents() {
        TreeSet sourceColumns = new TreeSet(this._analysisJobBuilder.getSourceColumns());
        ImageIcon validIcon = ImageManager.getInstance().getImageIcon("images/status/valid.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
        DefaultTableModel model = new DefaultTableModel(COLUMN_NAMES, sourceColumns.size());
        int i = 0;
        for (InputColumn inputColumn : sourceColumns) {
            Column column = inputColumn.getPhysicalColumn();
            model.setValueAt(column.getTable().getName(), i, 0);
            model.setValueAt(column.getName(), i, 1);
            model.setValueAt(column.getType(), i, 2);
            model.setValueAt(column.getNativeType(), i, 3);
            model.setValueAt(column.getColumnSize(), i, 4);
            Boolean nullable = column.isNullable();
            if (nullable != null && nullable.booleanValue()) {
                model.setValueAt(validIcon, i, 5);
            } else {
                model.setValueAt("", i, 5);
            }
            boolean indexed = column.isIndexed();
            if (indexed) {
                model.setValueAt(validIcon, i, 6);
            } else {
                model.setValueAt("", i, 6);
            }
            ++i;
        }
        this._table.setModel(model);
    }

    public void onAdd(InputColumn<?> sourceColumn) {
        this.updateComponents();
    }

    public void onRemove(InputColumn<?> sourceColumn) {
        this.updateComponents();
    }
}

