/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.job.concurrent.PreviousErrorsExistException;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DCProgressBar;
import org.eobjects.datacleaner.widgets.LoadingIcon;
import org.eobjects.metamodel.schema.Table;
import org.jdesktop.swingx.VerticalLayout;

public class ProgressInformationPanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private final ImageManager imageManager = ImageManager.getInstance();
    private final JTextArea _textArea = new JTextArea();
    private final DCPanel _progressBarPanel;
    private final Map<Table, DCProgressBar> _progressBars = new IdentityHashMap<Table, DCProgressBar>();
    private final JScrollPane _textAreaScroll;
    private final Map<Table, Integer> _verboseCounter = new IdentityHashMap<Table, Integer>();
    private final JButton _stopButton;
    private final LoadingIcon _loadingIcon;
    private final DCLabel _loadingLabel;
    private volatile boolean _verboseLogging = false;

    public ProgressInformationPanel() {
        this.setLayout(new BorderLayout());
        this._textArea.setText("--- DataCleaner progress information user-log ---");
        this._textArea.setEditable(false);
        this._textAreaScroll = WidgetUtils.scrolleable(this._textArea);
        this._textAreaScroll.setBorder(new CompoundBorder(WidgetUtils.BORDER_SHADOW, WidgetUtils.BORDER_THIN));
        this._progressBarPanel = new DCPanel(WidgetUtils.BG_COLOR_DARK, WidgetUtils.BG_COLOR_DARK);
        this._progressBarPanel.setLayout((LayoutManager)new VerticalLayout(4));
        this._progressBarPanel.setBorder(WidgetUtils.BORDER_EMPTY);
        this._loadingIcon = new LoadingIcon();
        this._loadingLabel = DCLabel.bright("Preparing...");
        this._loadingLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this._progressBarPanel.add(this._loadingIcon);
        this._progressBarPanel.add(this._loadingLabel);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setDividerLocation(240);
        splitPane.setBorder(null);
        splitPane.add(WidgetUtils.scrolleable(this._progressBarPanel));
        splitPane.add(this._textAreaScroll);
        final JCheckBox verboseCheckBox = new JCheckBox("Verbose logging?");
        verboseCheckBox.setOpaque(false);
        verboseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressInformationPanel.this._verboseLogging = verboseCheckBox.isSelected();
            }
        });
        this._stopButton = new JButton("Cancel job", this.imageManager.getImageIcon("images/actions/stop.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
        this._stopButton.setMargin(new Insets(1, 1, 1, 1));
        this._stopButton.setVisible(false);
        DCPanel bottomPanel = new DCPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)verboseCheckBox, "West");
        bottomPanel.add((Component)this._stopButton, "East");
        this.add((Component)splitPane, "Center");
        this.add((Component)bottomPanel, "South");
    }

    public String getTextAreaText() {
        return this._textArea.getText();
    }

    public void addStopActionListener(ActionListener actionListener) {
        this._stopButton.addActionListener(actionListener);
        this._stopButton.setVisible(true);
    }

    public void addUserLog(String string) {
        this.appendMessage("\nINFO: " + string);
    }

    public void addUserLog(String string, Throwable throwable, boolean jobFinished) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append("\nERROR: ");
        stringWriter.append(string);
        if (throwable instanceof PreviousErrorsExistException) {
            stringWriter.append(' ');
            stringWriter.append(throwable.getMessage());
        } else {
            stringWriter.append('\n');
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.printStackTrace(printWriter, throwable);
        }
        this.appendMessage(stringWriter.toString());
        if (jobFinished) {
            this._stopButton.setEnabled(false);
            this._loadingLabel.setText("Stopped!");
            this._loadingLabel.setVisible(true);
            this._loadingIcon.setVisible(false);
            Collection<DCProgressBar> progressBars = this._progressBars.values();
            for (DCProgressBar progressBar : progressBars) {
                progressBar.setEnabled(false);
                progressBar.setString("Stopped!");
            }
        }
    }

    protected void printStackTrace(PrintWriter printWriter, Throwable throwable) {
        throwable.printStackTrace(printWriter);
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            SQLException nextException;
            if (!(cause instanceof SQLException) || (nextException = ((SQLException)cause).getNextException()) == null) continue;
            printWriter.print("Next exception: ");
            this.printStackTrace(printWriter, nextException);
        }
    }

    private void appendMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressInformationPanel.this._textArea.append(message);
                JScrollBar verticalScrollBar = ProgressInformationPanel.this._textAreaScroll.getVerticalScrollBar();
                verticalScrollBar.setValue(verticalScrollBar.getMaximum());
            }
        });
    }

    public void setExpectedRows(Table table, int expectedRows) {
        final DCProgressBar progressBar = this.getProgressBar(table, expectedRows);
        final DCLabel tableLabel = DCLabel.bright(table.getName());
        final DCLabel rowsLabel = DCLabel.bright("Approx. " + expectedRows + " rows");
        rowsLabel.setFont(WidgetUtils.FONT_SMALL);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DCPanel dCPanel = ProgressInformationPanel.this._progressBarPanel;
                synchronized (dCPanel) {
                    if (ProgressInformationPanel.this._progressBarPanel.getComponentCount() == 0) {
                        ProgressInformationPanel.this._progressBarPanel.add(Box.createVerticalStrut(10));
                    }
                    ProgressInformationPanel.this._progressBarPanel.add(tableLabel);
                    ProgressInformationPanel.this._progressBarPanel.add(rowsLabel);
                    ProgressInformationPanel.this._progressBarPanel.add(progressBar);
                    ProgressInformationPanel.this._progressBarPanel.updateUI();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DCProgressBar getProgressBar(Table table, int expectedRows) {
        Map<Table, DCProgressBar> map = this._progressBars;
        synchronized (map) {
            DCProgressBar progressBar = this._progressBars.get(table);
            if (progressBar == null) {
                if (expectedRows == -1) {
                    expectedRows = Integer.MAX_VALUE;
                }
                progressBar = new DCProgressBar(0, expectedRows);
                this._progressBars.put(table, progressBar);
                this._loadingIcon.setVisible(false);
                this._loadingLabel.setVisible(false);
            } else if (expectedRows != -1) {
                progressBar.setMaximum(expectedRows);
            }
            return progressBar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(Table table, int currentRow) {
        DCProgressBar progressBar = this.getProgressBar(table, -1);
        progressBar.setValueIfHigherAndSignificant(currentRow);
        if (this._verboseLogging) {
            boolean log = false;
            Map<Table, Integer> map = this._verboseCounter;
            synchronized (map) {
                Integer previousCount = this._verboseCounter.get(table);
                if (previousCount == null) {
                    previousCount = 0;
                }
                if (currentRow - previousCount > 1000) {
                    this._verboseCounter.put(table, currentRow);
                    log = true;
                }
            }
            if (log) {
                this.addUserLog("Progress for table '" + table.getName() + "': Row no. " + currentRow);
            }
        }
    }

    public void onSuccess() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressInformationPanel.this._loadingIcon.setVisible(false);
                ProgressInformationPanel.this._loadingLabel.setVisible(false);
                ProgressInformationPanel.this._stopButton.setEnabled(false);
                Collection progressBars = ProgressInformationPanel.this._progressBars.values();
                for (DCProgressBar progressBar : progressBars) {
                    int maximum = progressBar.getMaximum();
                    progressBar.setValue(maximum);
                }
            }
        });
    }
}

