/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.LoadingIcon;
import org.eobjects.datacleaner.widgets.tree.SchemaTree;

public class SchemaTreePanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final InjectorBuilder _injectorBuilder;
    private JComponent _updatePanel;

    @Inject
    protected SchemaTreePanel(InjectorBuilder injectorBuilder) {
        super(imageManager.getImage("images/window/schema-tree-background.png", new ClassLoader[0]), 100, 100, WidgetUtils.BG_COLOR_BRIGHTEST, WidgetUtils.BG_COLOR_BRIGHT);
        this._injectorBuilder = injectorBuilder;
        this.setLayout(new BorderLayout());
        this.setDatastore(null, false);
    }

    public void setDatastore(final Datastore datastore, final boolean expandTree) {
        this.removeAll();
        if (datastore == null) {
            this.add((Component)new DCPanel().setPreferredSize(150, 150), "Center");
            return;
        }
        this.add((Component)new LoadingIcon().setPreferredSize(150, 150), "Center");
        new SwingWorker<SchemaTree, Void>(){

            @Override
            protected SchemaTree doInBackground() throws Exception {
                Injector injector = SchemaTreePanel.this._injectorBuilder.with(Datastore.class, (Object)datastore).createInjector();
                SchemaTree tree = (SchemaTree)injector.getInstance(SchemaTree.class);
                return tree;
            }

            @Override
            protected void done() {
                try {
                    SchemaTree schemaTree = (SchemaTree)this.get();
                    JScrollPane schemaTreeScroll = WidgetUtils.scrolleable((JComponent)((Object)schemaTree));
                    schemaTreeScroll.setHorizontalScrollBarPolicy(31);
                    schemaTree.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent e) {
                            SchemaTreePanel.this.updateParentPanel();
                        }
                    });
                    SchemaTreePanel.this.removeAll();
                    SchemaTreePanel.this.add((Component)schemaTreeScroll, "Center");
                    SchemaTreePanel.this.updateParentPanel();
                    if (expandTree) {
                        schemaTree.expandAll();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }.execute();
    }

    private void updateParentPanel() {
        if (this._updatePanel != null) {
            this._updatePanel.updateUI();
        }
    }

    public void setUpdatePanel(JComponent updatePanel) {
        this._updatePanel = updatePanel;
    }
}

