/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.table.DefaultTableModel;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.EnumComboBoxListRenderer;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.util.SimpleTableDef;
import org.jdesktop.swingx.JXTextField;

public class SimpleTableDefPanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private final DCTable _table;
    private final DefaultTableModel _tableModel;
    private final String _tableName;

    public SimpleTableDefPanel(SimpleTableDef tableDef) {
        this._tableName = tableDef.getName();
        String[] names = tableDef.getColumnNames();
        ColumnType[] types = tableDef.getColumnTypes();
        this._tableModel = new DefaultTableModel(new String[]{"Field name", "Type"}, 0);
        for (int i = 0; i < names.length; ++i) {
            this.addField(names[i], types[i]);
        }
        this._table = new DCTable(this._tableModel);
        this._table.setSortable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createButtonPanel(), "North");
        this.add((Component)this._table.toPanel(), "Center");
    }

    private DCPanel createButtonPanel() {
        JButton addButton = WidgetFactory.createSmallButton("images/actions/add.png");
        addButton.setText("Add field");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTableDefPanel.this.addField(null, null);
            }
        });
        JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
        removeButton.setText("Remove field");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTableDefPanel.this._tableModel.removeRow(SimpleTableDefPanel.this._tableModel.getRowCount() - 1);
            }
        });
        DCPanel buttonPanel = DCPanel.flow(Alignment.RIGHT, 10, 10, addButton, removeButton);
        return buttonPanel;
    }

    private void addField(String name, ColumnType columnType) {
        if (name == null) {
            name = "";
        }
        JXTextField nameTextField = WidgetFactory.createTextField();
        nameTextField.setText(name);
        if (columnType == null) {
            columnType = ColumnType.VARCHAR;
        }
        DCComboBox<ColumnType> typeComboBox = new DCComboBox<ColumnType>(this.getAvailableColumnTypes());
        typeComboBox.setRenderer(new EnumComboBoxListRenderer());
        typeComboBox.setSelectedItem(columnType);
        this._tableModel.addRow(new Object[]{nameTextField, typeComboBox});
        this.updateUI();
    }

    private ColumnType[] getAvailableColumnTypes() {
        return new ColumnType[]{ColumnType.VARCHAR, ColumnType.DECIMAL, ColumnType.INTEGER, ColumnType.BOOLEAN, ColumnType.DATE, ColumnType.TIME, ColumnType.TIMESTAMP, ColumnType.MAP, ColumnType.LIST, ColumnType.BINARY};
    }

    public SimpleTableDef getTableDef() {
        int rowCount = this._tableModel.getRowCount();
        String[] names = new String[rowCount];
        ColumnType[] types = new ColumnType[rowCount];
        for (int i = 0; i < types.length; ++i) {
            JXTextField nameTextField = (JXTextField)this._tableModel.getValueAt(i, 0);
            names[i] = nameTextField.getText();
            DCComboBox typeComboBox = (DCComboBox)this._tableModel.getValueAt(i, 1);
            types[i] = (ColumnType)typeComboBox.getSelectedItem();
        }
        return new SimpleTableDef(this._tableName, names, types);
    }
}

